/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.EightDot3NotationFilenameProblem;
import de.dal33t.powerfolder.disk.problem.EndIllegalCharsFilenameProblem;
import de.dal33t.powerfolder.disk.problem.IllegalCharsFilenameProblem;
import de.dal33t.powerfolder.disk.problem.IllegalModificationDateProblem;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ReservedWordFilenameProblem;
import de.dal33t.powerfolder.disk.problem.TooLongFilenameProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileProblemHelper {
    private static final String[] RESERVED_WORDS = new String[]{"CON", "PRN", "AUX", "CLOCK$", "NUL", "COM0", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT0", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final int MAX_FILENAME_LENGTH = 250;
    private static final String[] ILLEGAL_LINUX_CHARS = new String[]{"/"};
    private static final String[] ILLEGAL_WINDOWS_CHARS = new String[]{"\\"};
    private static final String[] ILLEGAL_MACOSX_CHARS = new String[0];
    private static final Date UNIX_TIME_ZERO = new Date(0L);
    private static final Date TEN_YEARS_IN_THE_FUTURE = new Date(System.currentTimeMillis() + 315360000000L);

    public static boolean hasProblems(FileInfo fileInfo) {
        return FileProblemHelper.hasFilenameProblems(fileInfo.getFilenameOnly()) || FileProblemHelper.hasIllegalModificationDate(fileInfo);
    }

    private static boolean hasIllegalModificationDate(FileInfo fileInfo) {
        if (fileInfo.isDeleted() || fileInfo.getModifiedDate() == null) {
            return false;
        }
        return fileInfo.getModifiedDate().before(UNIX_TIME_ZERO) || fileInfo.getModifiedDate().after(TEN_YEARS_IN_THE_FUTURE);
    }

    static boolean hasFilenameProblems(String string) {
        return FileProblemHelper.containsIllegalLinuxChar(string) || FileProblemHelper.containsIllegalMacOSXChar(string) || FileProblemHelper.containsIllegalWindowsChars(string) || FileProblemHelper.endsWithIllegalWindowsChar(string) || FileProblemHelper.isReservedWindowsFilename(string) || FileProblemHelper.is8dot3Notation(string) || FileProblemHelper.isTooLong(string);
    }

    public static List<Problem> getProblems(Controller controller, FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        String string = fileInfo.getFilenameOnly();
        ArrayList<Problem> arrayList = new ArrayList<Problem>();
        if (PreferencesEntry.FILE_NAME_CHECK.getValueBoolean(controller).booleanValue()) {
            if (FileProblemHelper.containsIllegalLinuxChar(string)) {
                arrayList.add(new IllegalCharsFilenameProblem(fileInfo, ILLEGAL_LINUX_CHARS));
            }
            if (FileProblemHelper.containsIllegalMacOSXChar(string)) {
                arrayList.add(new IllegalCharsFilenameProblem(fileInfo, ILLEGAL_MACOSX_CHARS));
            }
            if (FileProblemHelper.containsIllegalWindowsChars(string)) {
                arrayList.add(new IllegalCharsFilenameProblem(fileInfo, ILLEGAL_WINDOWS_CHARS));
            }
            if (FileProblemHelper.endsWithIllegalWindowsChar(string)) {
                arrayList.add(new EndIllegalCharsFilenameProblem(fileInfo));
            }
            if (FileProblemHelper.isReservedWindowsFilename(string)) {
                arrayList.add(new ReservedWordFilenameProblem(fileInfo));
            }
            if (FileProblemHelper.is8dot3Notation(string)) {
                arrayList.add(new EightDot3NotationFilenameProblem(fileInfo));
            }
            if (FileProblemHelper.isTooLong(string)) {
                arrayList.add(new TooLongFilenameProblem(fileInfo));
            }
            if (FileProblemHelper.hasIllegalModificationDate(fileInfo)) {
                arrayList.add(new IllegalModificationDateProblem(fileInfo));
            }
        }
        return arrayList;
    }

    static boolean isReservedWindowsFilename(String string) {
        String string2 = FileProblemHelper.stripExtension(string).toUpperCase();
        for (String string3 : RESERVED_WORDS) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static String stripExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    static boolean containsIllegalWindowsChars(String string) {
        for (String string2 : ILLEGAL_WINDOWS_CHARS) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIllegalWindowsChar(String string) {
        return string.endsWith(".") || string.endsWith(" ");
    }

    private static boolean containsIllegalMacOSXChar(String string) {
        for (String string2 : ILLEGAL_MACOSX_CHARS) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsIllegalLinuxChar(String string) {
        for (String string2 : ILLEGAL_LINUX_CHARS) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTooLong(String string) {
        return string.length() > 250;
    }

    public static boolean is8dot3Notation(String string) {
        int n = string.lastIndexOf(126);
        if (n < 0 || n == string.length() - 1) {
            return false;
        }
        int n2 = string.lastIndexOf(92);
        if (n2 >= 0) {
            return FileProblemHelper.is8dot3Notation(string.substring(n2 + 1));
        }
        int n3 = string.indexOf(46, n + 1);
        if (n3 < 0) {
            return false;
        }
        String string2 = string.substring(n + 1, n3);
        try {
            Integer.valueOf(string2);
            return string.toUpperCase().equals(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static void resolve(Controller controller, FileInfo fileInfo, String string, Problem problem) {
        Folder folder = controller.getFolderRepository().getFolder(fileInfo.getFolderInfo());
        Path path = folder.getDiskFile(fileInfo);
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Path path2 = PathUtils.buildFileFromRelativeName(folder.getLocalBase(), string);
        try {
            Files.move(path, path2, new CopyOption[0]);
            FileInfo fileInfo2 = FileInfoFactory.newFile(folder, path2, fileInfo.getOID(), controller.getMySelf().getInfo(), controller.getMySelf().getAccountInfo(), fileInfo.getHashes(), false, fileInfo.getTags());
            if (folder.isKnown(fileInfo)) {
                folder.removeFilesLocal(fileInfo);
            }
            folder.scanChangedFile(fileInfo2);
            fileInfo.getFolder(controller.getFolderRepository()).removeProblem(problem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String removeChars(String string, String[] stringArray) {
        Object object = string;
        for (String string2 : stringArray) {
            while (((String)object).contains(string2)) {
                int n = ((String)object).indexOf(string2);
                object = ((String)object).substring(0, n) + ((String)object).substring(n + 1, ((String)object).length());
            }
        }
        return object;
    }

    private static boolean isUnique(Controller controller, String string, FileInfo fileInfo) {
        Folder folder = controller.getFolderRepository().getFolder(fileInfo.getFolderInfo());
        int n = fileInfo.getRelativeName().lastIndexOf(47);
        String string2 = n > 0 ? fileInfo.getRelativeName().substring(n, fileInfo.getRelativeName().length()) : "/";
        Path path = PathUtils.buildFileFromRelativeName(folder.getLocalBase(), string2 + string);
        return Files.notExists(path, new LinkOption[0]);
    }

    static String getShorterFilename(Controller controller, FileInfo fileInfo) {
        int n = Math.min(250, fileInfo.getFilenameOnly().length());
        while (!FileProblemHelper.isUnique(controller, fileInfo.getFilenameOnly().substring(0, n), fileInfo)) {
            if (--n >= 1) continue;
            throw new IllegalStateException("Length too small when shortening " + fileInfo.getFilenameOnly());
        }
        return fileInfo.getFilenameOnly().substring(0, n);
    }

    static String makeUnique(Controller controller, FileInfo fileInfo) {
        String string = fileInfo.getFilenameOnly();
        String string2 = "";
        if (string.contains(".")) {
            string2 = string.substring(string.lastIndexOf(46));
            string = string.substring(0, string.lastIndexOf(46));
        }
        Object object = "-1";
        int n = 1;
        while (!FileProblemHelper.isUnique(controller, string + (String)object + string2, fileInfo)) {
            object = "-" + n++;
            if (n < 1000) continue;
            throw new IllegalStateException("Unable to fina a unique filename. Ended at: " + string + (String)object + string2);
        }
        return string + (String)object + string2;
    }
}

