/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Translation;

public class EightDot3NotationFilenameProblem
extends ResolvableProblem {
    private final String description;
    private final FileInfo fileInfo;

    public EightDot3NotationFilenameProblem(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        this.description = Translation.get("filename_problem.8dot3notation", fileInfo.getFilenameOnly());
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWikiLinkKey() {
        return null;
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.fileInfo.getFolder(controller.getFolderRepository());
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                Folder folder = EightDot3NotationFilenameProblem.this.fileInfo.getFolderInfo().getFolder(controller);
                if (folder != null) {
                    controller.getFolderRepository().addToIgnoredFolders(folder);
                    controller.getFolderRepository().removeFolder(folder, false);
                }
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("filename_problem.8dot3notation.soln_desc");
    }

    public String toString() {
        return "EightDot3NotationFilenameProblem{fileInfo=" + this.fileInfo + ",description='" + this.description + "'}";
    }
}

