/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Translation;

public class DuplicateFilenameProblem
extends ResolvableProblem {
    private final String description;
    private final FileInfo fileInfo;

    public DuplicateFilenameProblem(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        this.description = Translation.get("filename_problem.duplicate", fileInfo.getFilenameOnly());
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWikiLinkKey() {
        return "Duplicate-Filename";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.fileInfo.getFolder(controller.getFolderRepository());
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                String string = FileProblemHelper.makeUnique(controller, DuplicateFilenameProblem.this.fileInfo);
                FileProblemHelper.resolve(controller, DuplicateFilenameProblem.this.fileInfo, string, DuplicateFilenameProblem.this);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("filename_problem.duplicate.soln_desc");
    }
}

