/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.util.Date;

public class DeviceDisconnectedProblem
extends ResolvableProblem {
    private final FolderInfo folderInfo;
    private final Date created;

    public DeviceDisconnectedProblem(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder");
        this.folderInfo = folderInfo;
        this.created = new Date();
    }

    @Override
    public String getDescription() {
        return Translation.get("folder_problem.device_disconnected");
    }

    @Override
    public String getWikiLinkKey() {
        return "Disconnected-Device";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folderInfo.getFolder(controller);
    }

    public Date getCreated() {
        return this.created;
    }

    public String toString() {
        return "StorageDisconnectedProblem{folderInfo=" + this.folderInfo + ", since=" + this.created + "}";
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                final Folder folder = controller.getFolderRepository().getFolder(DeviceDisconnectedProblem.this.folderInfo);
                if (folder != null) {
                    controller.getIOProvider().startIO(new Runnable(){

                        @Override
                        public void run() {
                            controller.getFolderRepository().removeFolder(folder, false);
                        }
                    });
                }
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("folder_problem.device_disconnected.remove_folder");
    }
}

