/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Reject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanResult {
    private ResultState resultState = ResultState.SCANNED;
    Collection<FileInfo> newFiles;
    Collection<FileInfo> changedFiles;
    Collection<FileInfo> deletedFiles;
    Map<FileInfo, FileInfo> movedFiles;
    Collection<FileInfo> restoredFiles;
    private Map<FileInfo, List<Problem>> problemFiles;
    private volatile int totalFilesCount;

    public ScanResult(ResultState resultState) {
        this(false);
        Reject.ifNull((Object)resultState, "Result state is null");
        this.resultState = resultState;
    }

    public ScanResult(boolean bl) {
        if (bl) {
            this.newFiles = Collections.synchronizedList(new ArrayList());
            this.changedFiles = Collections.synchronizedList(new ArrayList());
            this.deletedFiles = Collections.synchronizedList(new ArrayList());
            this.movedFiles = Collections.synchronizedMap(new HashMap());
            this.restoredFiles = Collections.synchronizedList(new ArrayList());
            this.problemFiles = Collections.synchronizedMap(new HashMap());
        }
    }

    public boolean isChangeDetected() {
        return !this.changedFiles.isEmpty() || !this.deletedFiles.isEmpty() || !this.newFiles.isEmpty() || !this.movedFiles.isEmpty() || !this.restoredFiles.isEmpty();
    }

    public Collection<FileInfo> getChangedFiles() {
        return Collections.unmodifiableCollection(this.changedFiles);
    }

    public Collection<FileInfo> getDeletedFiles() {
        return Collections.unmodifiableCollection(this.deletedFiles);
    }

    public Map<FileInfo, FileInfo> getMovedFiles() {
        return Collections.unmodifiableMap(this.movedFiles);
    }

    public Collection<FileInfo> getNewFiles() {
        return Collections.unmodifiableCollection(this.newFiles);
    }

    public Map<FileInfo, List<Problem>> getProblemFiles() {
        return Collections.unmodifiableMap(this.problemFiles);
    }

    public void setProblemFiles(Map<FileInfo, List<Problem>> map) {
        this.problemFiles = map;
    }

    public int getTotalFilesCount() {
        return this.totalFilesCount;
    }

    public Collection<FileInfo> getRestoredFiles() {
        return Collections.unmodifiableCollection(this.restoredFiles);
    }

    public void putFileProblems(FileInfo fileInfo, List<Problem> list) {
        this.problemFiles.put(fileInfo, list);
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public void setResultState(ResultState resultState) {
        this.resultState = resultState;
    }

    public void incrementTotalFilesCount() {
        ++this.totalFilesCount;
    }

    public String toString() {
        return this.resultState + ", Total files: " + this.totalFilesCount + ", Newfiles: " + this.newFiles.size() + ", changed files: " + this.changedFiles.size() + ", deleted files: " + this.deletedFiles.size() + " restoredFiles: " + this.restoredFiles.size() + ", movedFiles: " + this.movedFiles.size() + ", problemFiles: " + this.problemFiles.size();
    }

    public static enum ResultState {
        SCANNED,
        USER_ABORT,
        FAILURE,
        BUSY;

    }
}

