/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.LockingEvent;
import de.dal33t.powerfolder.event.LockingListener;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Set;

public class Locking
extends PFComponent {
    private static final String LOCK_FILE_EXT = ".lck";
    private LockingListener listenerSupport = ListenerSupportFactory.createListenerSupport(LockingListener.class);
    private FolderLockListener folderLockListener = new FolderLockListener();

    Locking(Controller controller) {
        super(controller);
    }

    public void start() {
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders(true);
        for (Folder folder : collection) {
            if (!folder.getInfo().isMetaFolder()) continue;
            folder.addFolderListener(this.folderLockListener);
        }
    }

    public void shutdown() {
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders();
        for (Folder folder : collection) {
            folder.removeFolderListener(this.folderLockListener);
        }
    }

    public boolean lock(FileInfo fileInfo) {
        return this.lock(fileInfo, this.getMySelf().getAccountInfo());
    }

    public boolean lock(FileInfo fileInfo, AccountInfo accountInfo) {
        Object object;
        Reject.ifNull(fileInfo, "FileInfo");
        Lock lock = new Lock(fileInfo, this.getMySelf().getInfo(), accountInfo);
        Path path = this.getLockFile(fileInfo);
        if (path == null) {
            return false;
        }
        if (Files.exists(path, new LinkOption[0]) && this.isWarning() && (object = (Object)this.getLock(fileInfo)) != null && !Util.equals(((Lock)object).getAccountInfo(), accountInfo)) {
            this.logWarning("Overwriting existing lock of file " + fileInfo + " by " + ((Lock)object).getAccountInfo());
        }
        try {
            object = ByteSerializer.serializeStatic(lock, false);
            PathUtils.copyFromStreamToFile(new ByteArrayInputStream((byte[])object), path);
            this.scanLockFile(fileInfo, path);
            this.fireLocked(fileInfo);
            this.setWritableIfFromOtherMember(fileInfo, lock, false);
            if (this.isInfo()) {
                this.logInfo((accountInfo != null ? accountInfo.getUsername() : "?") + " locked the file " + fileInfo.toDetailString());
            }
            return true;
        }
        catch (IOException iOException) {
            this.logWarning("Unable to create lock file: " + path + ". " + iOException);
            return false;
        }
    }

    public boolean unlock(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        Path path = this.getLockFile(fileInfo);
        if (path == null) {
            return true;
        }
        try {
            boolean bl = Files.deleteIfExists(path);
            if (bl) {
                this.scanLockFile(fileInfo, path);
                this.fireUnlocked(fileInfo);
                this.setWritableIfFromOtherMember(fileInfo, null, true);
                this.logInfo("File un-locked: " + fileInfo.toDetailString());
            }
            return true;
        }
        catch (IOException iOException) {
            try {
                Thread.sleep(200L);
                boolean bl = Files.deleteIfExists(path);
                if (bl) {
                    this.scanLockFile(fileInfo, path);
                    this.fireUnlocked(fileInfo);
                    this.setWritableIfFromOtherMember(fileInfo, null, true);
                    this.logInfo("File un-locked: " + fileInfo.toDetailString());
                }
                return true;
            }
            catch (IOException iOException2) {
                this.logWarning("Unable to remove lock file: " + path + ". " + iOException);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    public boolean isLocked(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        Path path = this.getLockFile(fileInfo);
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    public boolean isEditing(FileInfo fileInfo) {
        Lock lock = this.getLock(fileInfo);
        if (lock != null) {
            if (lock.getMemberInfo().equals(this.getMySelf().getInfo())) {
                return true;
            }
            boolean bl = this.getController().getNodeManager().getNodesAsCollection().stream().filter(Member::isServer).anyMatch(member -> member.getInfo().equals(lock.getMemberInfo()));
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public Lock getLock(FileInfo fileInfo) {
        Path path = this.getLockFile(fileInfo);
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        return this.getLock(path);
    }

    private Path getLockFile(FileInfo fileInfo) {
        Folder folder = this.getController().getFolderRepository().getMetaFolder(fileInfo.getFolderInfo());
        if (folder == null) {
            this.logWarning("Meta-folder for " + fileInfo.getFolderInfo() + " not found");
            return null;
        }
        Path path = folder.getLocalBase().resolve("locks");
        return path.resolve(FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName() + LOCK_FILE_EXT));
    }

    public Lock getLock(Path path) {
        Lock lock;
        block9: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                byte[] byArray = StreamUtils.readIntoByteArray(inputStream);
                lock = (Lock)ByteSerializer.deserializeStatic(byArray, false);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EOFException eOFException) {
                    return null;
                }
                catch (Exception exception) {
                    this.logWarning("Problems while reading lock file: " + path + ". " + exception);
                    return null;
                }
            }
            inputStream.close();
        }
        return lock;
    }

    public void lockStateChanged(FileInfo fileInfo) {
        FileInfo fileInfo2 = this.getFileInfoFromLockFileInfo(fileInfo);
        Lock lock = this.getLock(fileInfo2);
        this.setWritableIfFromOtherMember(fileInfo2, lock, fileInfo.isDeleted());
        if (fileInfo.isDeleted()) {
            this.logInfo("File un-locked by remote: " + fileInfo2.toDetailString());
            this.fireUnlocked(fileInfo2);
        } else {
            this.logInfo("File locked by remote: " + fileInfo2.toDetailString());
            this.fireLocked(fileInfo2);
        }
    }

    public void handlePotentialLockfile(FileInfo fileInfo) {
        boolean bl;
        Reject.ifNull(fileInfo, "FileInfo");
        boolean bl2 = fileInfo.getRelativeName().contains("~$");
        if (bl2) {
            this.autoLockMSOfficeFiles(fileInfo);
        }
        if (bl = fileInfo.getRelativeName().contains(".~lock.")) {
            this.autoLockLibreOfficeFiles(fileInfo);
        }
    }

    private void autoLockMSOfficeFiles(FileInfo fileInfo) {
        FileInfo fileInfo2 = fileInfo.getLocalFileInfo(this.getController().getFolderRepository());
        if (fileInfo2 == null) {
            return;
        }
        int n = fileInfo2.getRelativeName().indexOf("~$");
        if (n < 0) {
            return;
        }
        String string = fileInfo2.getFilenameOnly();
        if (!string.startsWith("~$")) {
            return;
        }
        String string2 = fileInfo2.getRelativeName().replace("~$", "");
        FileInfo fileInfo3 = FileInfoFactory.lookupInstance(fileInfo2.getFolderInfo(), string2);
        if ((fileInfo3 = fileInfo3.getLocalFileInfo(this.getController().getFolderRepository())) == null) {
            Folder folder = fileInfo2.getFolder(this.getController().getFolderRepository());
            int n2 = string2.indexOf("/");
            if (n2 >= 0) {
                string2 = string2.substring(n2 + 1);
            }
            for (FileInfo fileInfo4 : folder.getKnownFiles()) {
                if (fileInfo4.isDeleted() || !fileInfo4.getRelativeName().endsWith(string2) || fileInfo4.getRelativeName().contains("~$")) continue;
                fileInfo3 = fileInfo4;
                break;
            }
            if (fileInfo3 == null) {
                return;
            }
        }
        if (!this.isAutoLockingAllowed(fileInfo3)) {
            if (!fileInfo2.isDeleted()) {
                this.fireAutoLockForbidden(fileInfo3);
            }
            return;
        }
        if (fileInfo2.isDeleted()) {
            this.unlock(fileInfo3);
        } else {
            this.lock(fileInfo3);
        }
    }

    private void autoLockLibreOfficeFiles(FileInfo fileInfo) {
        FileInfo fileInfo2 = fileInfo.getLocalFileInfo(this.getController().getFolderRepository());
        if (fileInfo2 == null) {
            return;
        }
        int n = fileInfo2.getRelativeName().indexOf(".~lock.");
        if (n < 0) {
            return;
        }
        String string = fileInfo2.getFilenameOnly();
        if (!string.startsWith(".~lock.")) {
            return;
        }
        String string2 = fileInfo2.getRelativeName().replace(".~lock.", "");
        string2 = string2.replace("#", "");
        FileInfo fileInfo3 = FileInfoFactory.lookupInstance(fileInfo2.getFolderInfo(), string2);
        if ((fileInfo3 = fileInfo3.getLocalFileInfo(this.getController().getFolderRepository())) == null) {
            return;
        }
        if (!this.isAutoLockingAllowed(fileInfo3)) {
            if (!fileInfo2.isDeleted()) {
                this.fireAutoLockForbidden(fileInfo3);
            }
            return;
        }
        if (fileInfo2.isDeleted()) {
            this.unlock(fileInfo3);
        } else {
            this.lock(fileInfo3);
        }
    }

    private boolean isAutoLockingAllowed(FileInfo fileInfo) {
        Lock lock = fileInfo.getLock(this.getController());
        if (lock == null) {
            return true;
        }
        boolean bl = this.getController().getMySelf().getInfo().equals(lock.getMemberInfo());
        AccountInfo accountInfo = lock.getAccountInfo();
        ServerClient serverClient = this.getController().getOSClient();
        AccountInfo accountInfo2 = serverClient.getAccountInfo();
        boolean bl2 = Util.equals(accountInfo, accountInfo2);
        return bl && bl2;
    }

    private FileInfo getFileInfoFromLockFileInfo(FileInfo fileInfo) {
        String string = fileInfo.getRelativeName();
        string = string.replace("locks/", "");
        string = string.replace(LOCK_FILE_EXT, "");
        FolderInfo folderInfo = fileInfo.getFolderInfo().lookupContentFolderInfo();
        return FileInfoFactory.lookupInstance(folderInfo, string);
    }

    private void setWritableIfFromOtherMember(FileInfo fileInfo, Lock lock, boolean bl) {
        if (!ConfigurationEntry.LOCKING_CHANGES_FILE_PERMISSIONS.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        if (lock != null && this.getController().getMySelf().getId().equals(lock.getMemberInfo().getId())) {
            this.logFine("Don't change permissions, if lock set on same member.");
            return;
        }
        Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            this.logInfo("Could not get file on storage for " + fileInfo + ". Not changing permission.");
            return;
        }
        try {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
            if (bl) {
                set.add(PosixFilePermission.OWNER_WRITE);
            } else {
                set.remove((Object)PosixFilePermission.OWNER_WRITE);
            }
            Files.setPosixFilePermissions(path, set);
            this.logInfo("Set " + path + " to " + (bl ? "writable" : "read only"));
        }
        catch (IOException iOException) {
            this.logWarning("Could not change file permissions for " + path);
        }
    }

    private boolean isLockfile(FileInfo fileInfo) {
        boolean bl = fileInfo.getFolderInfo().isMetaFolder();
        boolean bl2 = fileInfo.getRelativeName().startsWith("locks");
        boolean bl3 = fileInfo.getFilenameOnly().endsWith(LOCK_FILE_EXT);
        return bl && bl2 && bl3;
    }

    public void addListener(LockingListener lockingListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, lockingListener);
    }

    public void removeListener(LockingListener lockingListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, lockingListener);
    }

    private void fireLocked(FileInfo fileInfo) {
        LockingEvent lockingEvent = new LockingEvent(fileInfo);
        this.listenerSupport.locked(lockingEvent);
    }

    private void fireUnlocked(FileInfo fileInfo) {
        LockingEvent lockingEvent = new LockingEvent(fileInfo);
        this.listenerSupport.unlocked(lockingEvent);
    }

    private void fireAutoLockForbidden(FileInfo fileInfo) {
        LockingEvent lockingEvent = new LockingEvent(fileInfo);
        this.listenerSupport.autoLockForbidden(lockingEvent);
    }

    private void scanLockFile(FileInfo fileInfo, Path path) {
        Folder folder = this.getController().getFolderRepository().getMetaFolder(fileInfo.getFolderInfo());
        if (folder == null) {
            this.logWarning("Meta-folder for " + fileInfo.getFolderInfo() + " not found");
            return;
        }
        FileInfo fileInfo2 = FileInfoFactory.lookupInstance(folder, path);
        if (folder.scanChangedFile(fileInfo2 = FileInfoFactory.changeModifiedAccount(fileInfo2, fileInfo.getModifiedByAccount())) == null) {
            this.logFine("Scanning of lock file not necessary: " + fileInfo2);
        }
    }

    public class FolderLockListener
    extends FolderAdapter {
        @Override
        public void scanResultCommitted(FolderEvent folderEvent) {
            if (!ConfigurationEntry.LOCKING_CHANGES_FILE_PERMISSIONS.getValueBoolean(Locking.this.getController()).booleanValue()) {
                return;
            }
            Collection<FileInfo> collection = folderEvent.getScanResult().getDeletedFiles();
            for (FileInfo fileInfo : collection) {
                if (!Locking.this.isLockfile(fileInfo)) continue;
                FileInfo fileInfo2 = Locking.this.getFileInfoFromLockFileInfo(fileInfo);
                Lock lock = Locking.this.getLock(fileInfo2);
                Locking.this.setWritableIfFromOtherMember(fileInfo2, lock, true);
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

