/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.event.DiskItemFilterListener;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.event.PatternChangedEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderStatisticInfo;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.SimpleTimeEstimator;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Util;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderStatistic
extends PFComponent {
    private static final Logger LOG = Logger.getLogger(FolderStatistic.class.getName());
    public static final int UNKNOWN_SYNC_STATUS = -1;
    private final Folder folder;
    private final long maxDelay;
    private volatile FolderStatisticInfo previous;
    private volatile FolderStatisticInfo calculating;
    private volatile FolderStatisticInfo current;
    private SimpleTimeEstimator estimator;
    private Date lastFileChangeDate;
    private TransferCounter downloadCounter;
    private volatile MyCalculatorTask calculatorTask;
    private NodeManagerListener nodeManagerListener;
    private Object calculatorInit = new Object();

    FolderStatistic(Folder folder) {
        super(folder.getController());
        this.estimator = new SimpleTimeEstimator();
        this.folder = folder;
        this.downloadCounter = new TransferCounter();
        this.maxDelay = 1000L * (long)ConfigurationEntry.FOLDER_STATS_CALC_TIME.getValueInt(this.getController()).intValue();
        MyFolderListener myFolderListener = new MyFolderListener();
        folder.addFolderListener(myFolderListener);
        folder.addMembershipListener(myFolderListener);
        folder.getDiskItemFilter().addListener(myFolderListener);
        this.nodeManagerListener = new MyNodeManagerListener();
        this.getController().getNodeManager().addWeakNodeManagerListener(this.nodeManagerListener);
        if (!folder.isDeviceDisconnected()) {
            Path path = folder.getSystemSubDir().resolve("FolderStatistic");
            this.current = FolderStatisticInfo.load(path);
        }
        if (this.current == null) {
            this.current = new FolderStatisticInfo(folder.getInfo());
        }
    }

    public long scheduleCalculate() {
        if (this.calculating != null) {
            return -1L;
        }
        if (!this.getController().getFolderRepository().hasJoinedFolder(this.folder.getInfo())) {
            this.logFine("Unable to calc stats. Folder not joined");
            return -1L;
        }
        if (this.calculatorTask != null) {
            return -1L;
        }
        long l = this.current.getAnalyzedFiles() / 1000;
        l = Math.max(100L, l);
        l = Math.min(l, this.maxDelay);
        l = this.setCalculateIn(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long setCalculateIn(long l) {
        Object object = this.calculatorInit;
        synchronized (object) {
            if (this.calculatorTask != null) {
                return -1L;
            }
            this.calculatorTask = new MyCalculatorTask();
            try {
                double d = Math.random() * (double)(this.getController().getFolderRepository().getFoldersCount() + 100) * 2.0;
                long l2 = l + (long)d;
                this.getController().schedule(this.calculatorTask, l2);
                return l2;
            }
            catch (IllegalStateException illegalStateException) {
                this.logFiner("IllegalStateException", illegalStateException);
                return -1L;
            }
        }
    }

    public synchronized void calculate0() {
        this.calculate0(true);
    }

    public synchronized void calculate0(boolean bl) {
        Comparable<Path> comparable;
        if (this.isFiner()) {
            this.logFiner("-------------Recalculation statistics on " + this.folder);
        }
        if (!this.folder.isStarted()) {
            return;
        }
        long l = System.currentTimeMillis();
        ProfilingEntry profilingEntry = Profiling.start();
        this.calculating = new FolderStatisticInfo(this.folder.getInfo());
        Collection<Member> collection = this.folder.getMembersAsCollection();
        ArrayList<Member> arrayList = new ArrayList<Member>(collection.size());
        for (Member member : collection) {
            if (!member.isCompletelyConnected() && !member.isMySelf() || !this.calculateMemberStats(member, arrayList)) continue;
            arrayList.add(member);
        }
        this.calculating.setEstimatedSyncDate(this.estimator.updateEstimate(this.calculating.getAverageSyncPercentage()));
        long l2 = System.currentTimeMillis();
        this.calculating.setArchiveSize(this.folder.getFileArchiver().getSize());
        long l3 = System.currentTimeMillis() - l2;
        if (l3 > 60000L && this.isWarning()) {
            this.logWarning(this.folder + ": Calculating archive size took " + l3 / 1000L + "s. Size: " + Format.formatBytesShort(this.folder.getFileArchiver().getSize()));
        }
        this.calculating.getPartialSyncStatMap().putAll(this.current.getPartialSyncStatMap());
        this.previous = this.current;
        this.current = this.calculating;
        this.calculating = null;
        if (bl && !this.folder.isDeviceDisconnected()) {
            comparable = this.folder.getSystemSubDir().resolve("FolderStatistic.writing");
            Path path = this.folder.getSystemSubDir().resolve("FolderStatistic");
            FolderStatisticInfo serializable = FolderStatisticInfo.load(path);
            if (!this.current.equals(serializable) && this.current.save((Path)comparable)) {
                try {
                    Files.deleteIfExists(path);
                    Files.move(comparable, path, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    try {
                        Files.copy(comparable, path, new CopyOption[0]);
                        Files.delete(comparable);
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }
        comparable = null;
        for (FileInfo fileInfo : this.folder.getKnownFiles()) {
            if (fileInfo.getModifiedDate() == null || comparable != null && ((Date)comparable).compareTo(fileInfo.getModifiedDate()) >= 0) continue;
            comparable = fileInfo.getModifiedDate();
        }
        if (comparable != null) {
            this.lastFileChangeDate = comparable;
        }
        if (this.isFine()) {
            double d;
            long l4 = System.currentTimeMillis() - l;
            double d2 = d = l4 != 0L ? (double)((long)this.current.getAnalyzedFiles() / l4) : 0.0;
            if (!this.folder.getInfo().isMetaFolder()) {
                this.logFine(this.folder.getName() + ": Recalculation completed (" + this.current.getAnalyzedFiles() + " Files analyzed) in " + l4 + "ms. Performance: " + d + " ana/ms. Sync: " + this.getHarmonizedSyncPercentage() + ". Local count: " + this.folder.getStatistic().getLocalFilesCount() + ". Local size: " + this.folder.getStatistic().getLocalSize());
            }
        }
        Profiling.end(profilingEntry);
        this.folder.notifyStatisticsCalculated();
    }

    public Date getLastFileChangeDate() {
        return this.lastFileChangeDate;
    }

    private static boolean inSync(Member member, FileInfo fileInfo, FileInfo fileInfo2) {
        boolean bl;
        if (fileInfo2 == null) {
            throw new NullPointerException("Newest FileInfo not found of " + fileInfo.toDetailString());
        }
        if (fileInfo == null) {
            return false;
        }
        boolean bl2 = bl = !fileInfo2.isNewerThan(fileInfo) && !fileInfo.isNewerThan(fileInfo2);
        if (!fileInfo2.isDeleted() && bl && fileInfo2.getSize() != fileInfo.getSize() && !fileInfo.getFolderInfo().isMetaFolder() && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("File in sync, but size differs. Newest: " + fileInfo2.toDetailString() + "\n@" + member.getNick() + ":" + fileInfo.toDetailString());
        }
        return bl;
    }

    private boolean calculateMemberStats(Member member, Collection<Member> collection) {
        Collection<FileInfo> collection2 = this.folder.getFilesAsCollection(member);
        if (collection2 == null) {
            this.logWarning("Unable to calc stats on member, no filelist yet: " + member);
            return false;
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        for (FileInfo fileInfo : collection2) {
            boolean bl;
            FileInfo fileInfo2;
            Member member2;
            Iterator<Member> iterator;
            Map<FileInfo, Long> map;
            if (!this.folder.isStarted()) {
                return false;
            }
            this.calculating.setAnalyzedFiles(this.calculating.getAnalyzedFiles() + 1);
            if (fileInfo.isDeleted() || this.folder.getDiskItemFilter().isExcluded(fileInfo)) continue;
            FileInfo fileInfo3 = fileInfo.getNewestVersion(this.folder);
            FileInfo fileInfo4 = this.folder.getFile(fileInfo);
            if (fileInfo3 == null) {
                if (!this.folder.hasWritePermission(member) || !this.isFine()) continue;
                this.logFine("Newest version not found for " + fileInfo.toDetailString());
                continue;
            }
            boolean bl2 = FolderStatistic.inSync(member, fileInfo, fileInfo3);
            if (bl2 && (map = this.current.getPartialSyncStatMap().get(member.getInfo())) != null && (iterator = map.remove(fileInfo)) != null && this.isFiner()) {
                this.logFiner("Removed partial stat for " + member.getInfo().nick + ", " + fileInfo.getRelativeName() + ", " + iterator);
            }
            if (bl2 && !fileInfo3.isDeleted()) {
                boolean bl3 = true;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    member2 = iterator.next();
                    fileInfo2 = member2.getFile(fileInfo);
                    if (fileInfo2 == null || !(bl = FolderStatistic.inSync(member2, fileInfo2, fileInfo3))) continue;
                    bl3 = false;
                    break;
                }
                if (bl3 && (fileInfo4 == null || fileInfo3.isNewerThan(fileInfo4))) {
                    this.calculating.setIncomingFilesCount(this.calculating.getIncomingFilesCount() + 1);
                }
            }
            ++n;
            l += fileInfo.getSize();
            if (bl2) {
                ++n2;
                l2 += fileInfo.getSize();
            }
            if (!bl2) continue;
            boolean bl4 = !fileInfo3.isDeleted();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                member2 = iterator.next();
                fileInfo2 = member2.getFile(fileInfo);
                if (fileInfo2 == null || !(bl = FolderStatistic.inSync(member2, fileInfo2, fileInfo3))) continue;
                bl4 = false;
                break;
            }
            if (!bl4) continue;
            this.calculating.setTotalFilesCount(this.calculating.getTotalFilesCount() + 1);
            this.calculating.setTotalSize(this.calculating.getTotalSize() + fileInfo.getSize());
        }
        this.calculating.getFilesCount().put(member.getInfo(), n);
        this.calculating.getFilesCountInSync().put(member.getInfo(), n2);
        this.calculating.getSizes().put(member.getInfo(), l);
        this.calculating.getSizesInSync().put(member.getInfo(), l2);
        return true;
    }

    public String toString() {
        return "Folder statistic on '" + this.folder.getName() + "'";
    }

    public FolderStatisticInfo getPreviousInfo() {
        return this.previous;
    }

    public FolderStatisticInfo getInfo() {
        return this.current;
    }

    public long getTotalSize() {
        return this.current.getTotalSize();
    }

    public int getTotalFilesCount() {
        return this.current.getTotalFilesCount();
    }

    public int getIncomingFilesCount() {
        return this.current.getIncomingFilesCount();
    }

    public int getFilesCount(Member member) {
        Integer n = this.current.getFilesCount(member.getInfo());
        return n != null ? n : 0;
    }

    public int getFilesCountInSync(Member member) {
        Integer n = this.current.getFilesCountInSync().get(member.getInfo());
        return n != null ? n : 0;
    }

    public long getSize(Member member) {
        Long l = this.current.getSize(member.getInfo());
        return l != null ? l : 0L;
    }

    public long getSizeInSync(Member member) {
        Long l = this.current.getSizesInSync().get(member.getInfo());
        return l != null ? l : 0L;
    }

    public int getLocalFilesCount() {
        Integer n = this.current.getFilesCount(this.getMySelf().getInfo());
        return n != null ? n : 0;
    }

    public double getSyncPercentage(Member member) {
        return this.current.getSyncPercentage(member.getInfo());
    }

    public double getLocalSyncPercentage() {
        return this.getSyncPercentage(this.getMySelf());
    }

    public double getAverageSyncPercentage() {
        return this.current.getAverageSyncPercentage();
    }

    public double getServerSyncPercentage() {
        double d = -1.0;
        for (Member member : this.folder.getMembersAsCollection()) {
            if (!member.isServer() || member.isMySelf()) continue;
            d = Math.max(this.folder.getStatistic().getSyncPercentage(member), d);
        }
        return d;
    }

    public double getHarmonizedSyncPercentage() {
        boolean bl;
        if (this.folder.getMembersCount() > 1 && (this.folder.getCompletelyConnectedMembersCount() == 0 || this.current.getSizesInSync().size() <= 1)) {
            return -1.0;
        }
        boolean bl2 = this.folder.getMembersCount() == 2;
        boolean bl3 = bl = SyncProfile.HOST_FILES.equals(this.folder.getSyncProfile()) || SyncProfile.BACKUP_SOURCE.equals(this.folder.getSyncProfile());
        if (bl2) {
            double d = this.getLocalSyncPercentage();
            for (Member member : this.folder.getConnectedMembers()) {
                double d2 = this.getSyncPercentage(member);
                if (d2 < 0.0) continue;
                d = Math.min(d, d2);
            }
            return d;
        }
        if (bl) {
            double d = 0.0;
            for (Member member : this.folder.getConnectedMembers()) {
                double d3 = this.getSyncPercentage(member);
                d = Math.max(d, d3);
            }
            return d;
        }
        if (SyncProfile.AUTOMATIC_SYNCHRONIZATION.equals(this.folder.getSyncProfile())) {
            if (this.folder.getMembersCount() == 1) {
                return -1.0;
            }
            return this.getLocalSyncPercentage();
        }
        return this.getLocalSyncPercentage();
    }

    public Date getEstimatedSyncDate() {
        return this.current.getEstimatedSyncDate();
    }

    public long getLocalSize() {
        Long l = this.current.getSize(this.getMySelf().getInfo());
        return l != null ? l : 0L;
    }

    public long getArchiveSize() {
        return this.current.getArchiveSize();
    }

    public long getServerSize() {
        long l = 0L;
        for (Member member : this.folder.getMembersAsCollection()) {
            if (!member.isServer()) continue;
            l = Math.max(this.folder.getStatistic().getSizeInSync(member), l);
        }
        return l;
    }

    public TransferCounter getDownloadCounter() {
        return this.downloadCounter;
    }

    public void putPartialSyncStat(FileInfo fileInfo, Member member, long l) {
        Map<FileInfo, Long> map;
        if (this.isFiner()) {
            this.logFiner("Partial stat for " + fileInfo.getRelativeName() + ", " + member.getInfo().nick + ", " + l);
        }
        if ((map = this.current.getPartialSyncStatMap().get(member.getInfo())) == null) {
            map = Util.createConcurrentHashMap(4);
            this.current.getPartialSyncStatMap().put(member.getInfo(), map);
        }
        map.put(fileInfo, l);
        if (this.current != null) {
            this.current.setEstimatedSyncDate(this.estimator.updateEstimate(this.current.getAverageSyncPercentage()));
        }
        this.folder.notifyStatisticsCalculated();
    }

    public void removePartialSyncStats(Member member) {
        this.current.getPartialSyncStatMap().remove(member.getInfo());
    }

    private class MyCalculatorTask
    extends TimerTask {
        private MyCalculatorTask() {
        }

        @Override
        public void run() {
            FolderStatistic.this.calculate0();
            FolderStatistic.this.calculatorTask = null;
        }

        public String toString() {
            return "FolderStatistic calculator for '" + FolderStatistic.this.folder;
        }
    }

    private class MyFolderListener
    extends FolderAdapter
    implements FolderMembershipListener,
    DiskItemFilterListener {
        private MyFolderListener() {
        }

        @Override
        public void memberJoined(FolderMembershipEvent folderMembershipEvent) {
            if (folderMembershipEvent.getMember().isCompletelyConnected()) {
                FolderStatistic.this.scheduleCalculate();
            }
        }

        @Override
        public void memberLeft(FolderMembershipEvent folderMembershipEvent) {
            if (FolderStatistic.this.getController().isStarted()) {
                FolderStatistic.this.scheduleCalculate();
            }
        }

        @Override
        public void remoteContentsChanged(FolderEvent folderEvent) {
            this.calculateIfRequired(folderEvent);
        }

        @Override
        public void scanResultCommitted(FolderEvent folderEvent) {
            if (folderEvent.getScanResult().isChangeDetected()) {
                FolderStatistic.this.scheduleCalculate();
            }
        }

        @Override
        public void fileChanged(FolderEvent folderEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        @Override
        public void filesDeleted(FolderEvent folderEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        @Override
        public void syncProfileChanged(FolderEvent folderEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        @Override
        public void archivePurged(FolderEvent folderEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        @Override
        public void statisticsCalculated(FolderEvent folderEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void patternAdded(PatternChangedEvent patternChangedEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        @Override
        public void patternRemoved(PatternChangedEvent patternChangedEvent) {
            FolderStatistic.this.scheduleCalculate();
        }

        private void calculateIfRequired(FolderEvent folderEvent) {
            if (folderEvent.getMember() != null && !folderEvent.getMember().isCompletelyConnected()) {
                return;
            }
            if (folderEvent.getMember() != null && !folderEvent.getMember().hasCompleteFileListFor(FolderStatistic.this.folder.getInfo())) {
                return;
            }
            FolderStatistic.this.scheduleCalculate();
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            this.calculateIfRequired(nodeManagerEvent);
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            this.calculateIfRequired(nodeManagerEvent);
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        private void calculateIfRequired(NodeManagerEvent nodeManagerEvent) {
            if (FolderStatistic.this.folder == null || FolderStatistic.this.folder.getStatistic() == null) {
                return;
            }
            FolderStatistic.this.folder.getStatistic().removePartialSyncStats(nodeManagerEvent.getNode());
            if (!FolderStatistic.this.folder.hasMember(nodeManagerEvent.getNode())) {
                return;
            }
            if (FolderStatistic.this.folder.getStatistic().getHarmonizedSyncPercentage() != 100.0) {
                FolderStatistic.this.scheduleCalculate();
                return;
            }
            if (!nodeManagerEvent.getNode().hasCompleteFileListFor(FolderStatistic.this.folder.getInfo()) && nodeManagerEvent.getNode().isConnected()) {
                return;
            }
            FolderStatistic.this.scheduleCalculate();
        }
    }
}

