/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.event.DiskItemFilterListener;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.PatternChangedEvent;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.pattern.DefaultExcludes;
import de.dal33t.powerfolder.util.pattern.Pattern;
import de.dal33t.powerfolder.util.pattern.PatternFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;

public class DiskItemFilter {
    private DiskItemFilterListener listenerSupport;
    private static final Logger log = Logger.getLogger(DiskItemFilter.class.getName());
    public static final String PATTERNS_FILENAME = "ignore.patterns";
    private static final String PATTERN_IGNORE_ALL = "*";
    private final Set<Pattern> patterns = new CopyOnWriteArraySet<Pattern>();
    private boolean dirty;

    public DiskItemFilter() {
        this.listenerSupport = ListenerSupportFactory.createListenerSupport(DiskItemFilterListener.class);
    }

    public void addListener(DiskItemFilterListener diskItemFilterListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, diskItemFilterListener);
    }

    public void addWeakListener(DiskItemFilterListener diskItemFilterListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, diskItemFilterListener, true);
    }

    public void removeListener(DiskItemFilterListener diskItemFilterListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, diskItemFilterListener);
    }

    public void removeAllListener() {
        ListenerSupportFactory.removeAllListeners(this.listenerSupport);
    }

    public void loadPatternsFrom(Path path, boolean bl) {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        int n = 0;
        try (BufferedReader bufferedReader = Files.newBufferedReader(path, Charset.forName("UTF-8"));){
            String string;
            HashSet<Pattern> hashSet = new HashSet<Pattern>();
            while ((string = bufferedReader.readLine()) != null) {
                Object object = string.trim();
                for (DefaultExcludes defaultExcludes : DefaultExcludes.values()) {
                    String string2;
                    if (!defaultExcludes.getPattern().contains(PATTERN_IGNORE_ALL) || !((String)object).equalsIgnoreCase(string2 = defaultExcludes.getPattern().replace(PATTERN_IGNORE_ALL, ""))) continue;
                    object = defaultExcludes.getPattern();
                    log.fine(path + ": Fixing pattern: " + string2 + " to " + defaultExcludes.getPattern());
                    ++n;
                }
                if (((String)object).endsWith("/")) {
                    object = (String)object + PATTERN_IGNORE_ALL;
                }
                if (((String)object).length() <= 0 || ((String)object).equals(PATTERN_IGNORE_ALL)) continue;
                hashSet.add(DiskItemFilter.createPattern((String)object));
            }
            boolean bl2 = true;
            if (hashSet.size() == this.patterns.size()) {
                for (Pattern pattern : hashSet) {
                    if (this.patterns.contains(pattern)) continue;
                    bl2 = false;
                    break;
                }
            } else {
                bl2 = false;
            }
            if (bl2) {
                log.fine("Received a pattern file identical to own, so ignoring it.");
                return;
            }
            log.fine("Received a pattern file different to own, so loading it.");
            for (Pattern pattern : this.patterns) {
                this.patterns.remove(pattern);
                this.listenerSupport.patternRemoved(new PatternChangedEvent(this, pattern.getPatternText(), false));
            }
            for (Pattern pattern : hashSet) {
                this.patterns.add(pattern);
                this.listenerSupport.patternAdded(new PatternChangedEvent(this, pattern.getPatternText(), true));
            }
            this.dirty = bl;
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Problem loading pattern from " + path + ". " + iOException);
        }
        if (n > 0) {
            log.fine(path + ": Fixed " + n + " ignore patterns.");
        }
    }

    public void savePatternsTo(Path path, boolean bl) {
        Object object;
        try {
            if (bl) {
                object = path.getParent().resolve(path.getFileName().toString() + ".backup");
                if (Files.exists(path, new LinkOption[0])) {
                    Files.deleteIfExists((Path)object);
                    Files.move(path, (Path)object, new CopyOption[0]);
                }
            }
        }
        catch (IOException iOException) {
            log.warning(iOException.getMessage());
            return;
        }
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Problem saving pattern to " + path + ". " + iOException);
                return;
            }
        }
        try {
            object = Files.newBufferedWriter(path, Convert.UTF8, new OpenOption[0]);
            try {
                for (Pattern pattern : this.patterns) {
                    ((Writer)object).write(pattern.getPatternText());
                    ((BufferedWriter)object).newLine();
                }
                this.dirty = false;
            }
            finally {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
            }
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Problem saving pattern to " + path + ". " + iOException);
            log.log(Level.FINER, iOException.toString(), iOException);
        }
    }

    private static Pattern createPattern(String string) {
        Reject.ifBlank(string, "Pattern is blank");
        String string2 = string.replaceAll("\\\\", "/").toLowerCase();
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return PatternFactory.createPattern(string2);
    }

    void addPattern(String string) {
        this.addPattern0(DiskItemFilter.createPattern(string));
    }

    private void addPattern0(Pattern pattern) {
        if (this.patterns.contains(pattern)) {
            return;
        }
        if (pattern.getPatternText().equals(PATTERN_IGNORE_ALL)) {
            return;
        }
        try {
            this.patterns.add(pattern);
            this.dirty = true;
            this.listenerSupport.patternAdded(new PatternChangedEvent(this, pattern.getPatternText(), true));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.log(Level.SEVERE, "Problem adding pattern " + pattern.getPatternText(), patternSyntaxException);
        }
    }

    void removeAllPatterns() {
        for (Pattern pattern : this.patterns) {
            this.patterns.remove(pattern);
            this.dirty = true;
            this.listenerSupport.patternRemoved(new PatternChangedEvent(this, pattern.getPatternText(), false));
        }
    }

    void removePattern(String string) {
        Pattern pattern = DiskItemFilter.createPattern(string);
        for (Pattern pattern2 : this.patterns) {
            if (!pattern2.equals(pattern)) continue;
            this.patterns.remove(pattern2);
            this.dirty = true;
            this.listenerSupport.patternRemoved(new PatternChangedEvent(this, pattern2.getPatternText(), false));
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private boolean isMatches(DiskItem diskItem) {
        block3: {
            block2: {
                if (!(diskItem instanceof DirectoryInfo)) break block2;
                DirectoryInfo directoryInfo = (DirectoryInfo)diskItem;
                String string = directoryInfo.getRelativeName() + "/*";
                for (Pattern pattern : this.patterns) {
                    if (!pattern.isMatch(string)) continue;
                    return true;
                }
                break block3;
            }
            if (!(diskItem instanceof FileInfo)) break block3;
            String string = diskItem.getRelativeName();
            for (Pattern pattern : this.patterns) {
                if (!pattern.isMatch(string)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getPatterns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Pattern pattern : this.patterns) {
            arrayList.add(pattern.getPatternText());
        }
        return arrayList;
    }

    public int filterFileInfos(List<FileInfo> list) {
        int n = 0;
        Iterator<FileInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            DiskItem diskItem = iterator.next();
            if (!this.isExcluded(diskItem)) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }

    public boolean isExcluded(DiskItem diskItem) {
        return this.isMatches(diskItem);
    }

    public boolean isExcluded(String string) {
        if (this.patterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isRetained(DiskItem diskItem) {
        return !this.isExcluded(diskItem);
    }
}

