/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.MessageListener;
import de.dal33t.powerfolder.message.clientserver.Request;
import de.dal33t.powerfolder.message.clientserver.Response;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.util.Reject;

public class RequestExecutor
extends PFComponent {
    private Object waitForResponseLock = new Object();
    private Member node;
    private DisconnectListener discoListener;
    private ResponseMessageListener messageListener;
    private String requestId;
    private Response response;

    public RequestExecutor(Controller controller, Member member) {
        super(controller);
        Reject.ifNull(member, "Node is null");
        this.node = member;
        this.discoListener = new DisconnectListener();
        this.messageListener = new ResponseMessageListener();
    }

    public synchronized Response execute(Request request) throws ConnectionException {
        if (!this.node.isConnected()) {
            throw new ConnectionException("Not connected to " + this.node.getNick());
        }
        this.response = null;
        this.requestId = request.getRequestId();
        if (this.isFiner()) {
            this.logFiner("Sending request to " + this.node.getNick() + " (" + this.requestId + "): " + request);
        }
        this.getController().getNodeManager().addNodeManagerListener(this.discoListener);
        this.node.addMessageListener(this.messageListener);
        this.node.sendMessage(request);
        try {
            this.waitForResponse(60L);
            if (this.response == null) {
                if (!this.node.isConnected()) {
                    throw new ConnectionException(this.node.getNick() + " disconnected");
                }
                throw new ConnectionException("Timeout to " + this.node.getNick());
            }
            if (this.isFiner()) {
                this.logFiner("Response from " + this.node.getNick() + " (" + this.requestId + "): " + this.response + " to " + request);
            }
        }
        finally {
            this.notifyAndcleanup();
        }
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse(long l) {
        Object object = this.waitForResponseLock;
        synchronized (object) {
            if (this.response != null) {
                return;
            }
            try {
                this.waitForResponseLock.wait(1000L * l);
            }
            catch (InterruptedException interruptedException) {
                this.logFine("Interrupted while waiting for response (" + this.node + "): " + interruptedException);
                this.logFiner("InterruptedException", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAndcleanup() {
        if (this.isFiner()) {
            this.logFiner("Cleanup of request: " + this.requestId);
        }
        Object object = this.waitForResponseLock;
        synchronized (object) {
            this.waitForResponseLock.notifyAll();
        }
        this.node.removeMessageListener(this.messageListener);
        this.getController().getNodeManager().removeNodeManagerListener(this.discoListener);
    }

    private class DisconnectListener
    extends NodeManagerAdapter {
        private DisconnectListener() {
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            if (!nodeManagerEvent.getNode().equals(RequestExecutor.this.node)) {
                return;
            }
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            if (!nodeManagerEvent.getNode().equals(RequestExecutor.this.node)) {
                return;
            }
            RequestExecutor.this.notifyAndcleanup();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class ResponseMessageListener
    implements MessageListener {
        private ResponseMessageListener() {
        }

        @Override
        public void handleMessage(Member member, Message message) {
            if (!member.equals(RequestExecutor.this.node)) {
                return;
            }
            if (!(message instanceof Response)) {
                return;
            }
            Response response = (Response)message;
            if (RequestExecutor.this.requestId.equals(response.requestId)) {
                RequestExecutor.this.response = response;
                RequestExecutor.this.notifyAndcleanup();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

