/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.util.Reject;

public enum SyncStatus {
    SYNC_OK,
    SYNCING,
    IGNORED,
    WARNING,
    LOCKED,
    NONE;


    public static SyncStatus of(Controller controller, FileInfo fileInfo) {
        return SyncStatus.of(controller, fileInfo, null);
    }

    public static SyncStatus of(Controller controller, FileInfo fileInfo, Folder folder) {
        Reject.ifNull(controller, "Controller");
        Reject.ifNull(fileInfo, "FileInfo");
        if (!controller.isStarted() || controller.isShuttingDown()) {
            return NONE;
        }
        if (folder == null && (folder = fileInfo.getFolder(controller.getFolderRepository())) == null) {
            return NONE;
        }
        if (fileInfo.equals(folder.getBaseDirectoryInfo())) {
            double d = folder.getStatistic().getHarmonizedSyncPercentage();
            if (folder.isTransferring()) {
                return SYNCING;
            }
            if (folder.isDeviceDisconnected()) {
                return WARNING;
            }
            if (folder.getCompletelyConnectedMembersCount() == 0 || d < 0.0) {
                return NONE;
            }
            if (d > 0.0 && d < 100.0) {
                return SYNCING;
            }
            return SYNC_OK;
        }
        if (fileInfo.isDiretory() && !fileInfo.isLocked(controller)) {
            return NONE;
        }
        if (fileInfo.isLookupInstance()) {
            fileInfo = folder.getDAO().find(fileInfo, null);
        }
        if (fileInfo == null) {
            return NONE;
        }
        if (folder.getCompletelyConnectedMembersCount() == 0) {
            return NONE;
        }
        if (folder.getDiskItemFilter().isExcluded(fileInfo)) {
            return IGNORED;
        }
        TransferManager transferManager = controller.getTransferManager();
        if (transferManager.isDownloading(fileInfo) || transferManager.isUploading(fileInfo)) {
            return SYNCING;
        }
        if (fileInfo.isLocked(controller)) {
            return LOCKED;
        }
        if (fileInfo.isNewerAvailable(controller.getFolderRepository())) {
            return SYNCING;
        }
        if (transferManager.getSourcesFor(fileInfo).isEmpty()) {
            return SYNCING;
        }
        return SYNC_OK;
    }
}

