/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.task.CreateFolderOnServerTask;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.wizard.ChooseDiskLocationPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteCommandManager
extends PFComponent
implements Runnable {
    private static final String FOLDER_SCRIPT_CONFIG_ID = "id";
    private static final String FOLDER_SCRIPT_CONFIG_NAME = "name";
    private static final String FOLDER_SCRIPT_CONFIG_DIR = "dir";
    private static final String FOLDER_SCRIPT_CONFIG_BACKUP_BY_SERVER = "backup_by_server";
    private static final String FOLDER_SCRIPT_CONFIG_SYNC_PROFILE = "syncprofile";
    private static final String FOLDER_SCRIPT_CONFIG_SILENT = "silent";
    private static final String FOLDER_SCRIPT_CONFIG_DL_SCRIPT = "dlscript";
    private static final Logger log = Logger.getLogger(RemoteCommandManager.class.getName());
    private static final String REMOTECOMMAND_PREFIX = "PowerFolder_RCON_COMMAND";
    private static final String ENCODING = "UTF8";
    public static final String QUIT = "QUIT";
    public static final String OPEN = "OPEN;";
    public static final String SHOW_UI = "SHOWUI;";
    public static final String MAKEFOLDER = "MAKEFOLDER;";
    public static final String REMOVEFOLDER = "REMOVEFOLDER;";
    public static final String COPYLINK = "COPYLINK;";
    public static final String RELOAD_CONFIG = "RELOADCONFIG;";
    private ServerSocket serverSocket;
    private Thread myThread;
    private static final String SUCCESS_PARAM = "success=true";

    public RemoteCommandManager(Controller controller) {
        super(controller);
    }

    public static boolean hasRunningInstance() {
        return RemoteCommandManager.hasRunningInstance(Integer.valueOf(ConfigurationEntry.NET_PORT_RCON.getDefaultValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRunningInstance(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n, 0, InetAddress.getByName(NetworkUtil.LOOPBACK_LOCALHOST_IPv4));
            log.fine("No running instance found");
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    log.log(Level.SEVERE, "Unable to close already running test socket. " + serverSocket, iOException);
                }
            }
        }
        log.warning("Running instance found");
        return true;
    }

    public static boolean sendCommand(String string) {
        return RemoteCommandManager.sendCommand(Integer.valueOf(ConfigurationEntry.NET_PORT_RCON.getDefaultValue()), string);
    }

    public static boolean sendCommand(int n, String string) {
        try {
            log.log(Level.INFO, "Sending remote command '" + string + "'");
            Socket socket = new Socket(NetworkUtil.LOOPBACK_LOCALHOST_IPv4, n);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), ENCODING));
            printWriter.println("PowerFolder_RCON_COMMAND;" + string);
            printWriter.flush();
            printWriter.close();
            socket.close();
            return true;
        }
        catch (ConnectException connectException) {
            log.log(Level.WARNING, "Unable to connect to running instance to send remote command: " + connectException.getMessage());
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Unable to send remote command", iOException);
        }
        return false;
    }

    public void start() {
        Integer n = ConfigurationEntry.NET_PORT_RCON.getValueInt(this.getController());
        try {
            this.serverSocket = new ServerSocket(n, 0, InetAddress.getByName(NetworkUtil.LOOPBACK_LOCALHOST_IPv4));
            this.myThread = new Thread((Runnable)this, "Remote command Manager");
            this.myThread.start();
        }
        catch (UnknownHostException unknownHostException) {
            log.warning("Unable to open remote command manager on port " + n + ": " + unknownHostException);
            log.log(Level.FINER, "UnknownHostException", unknownHostException);
        }
        catch (IOException iOException) {
            log.warning("Unable to open remote command manager on port " + n + ": " + iOException);
            log.log(Level.FINER, "IOException", iOException);
        }
    }

    public void shutdown() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                log.log(Level.FINER, "Unable to close rcon socket", iOException);
            }
        }
    }

    public int getPort() {
        if (this.serverSocket == null || this.serverSocket.isClosed()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.fine("Listening for remote commands on port " + this.serverSocket.getLocalPort());
        while (!Thread.currentThread().isInterrupted()) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                log.log(Level.FINER, "Rcon socket closed, stopping", iOException);
                break;
            }
            log.finer("Remote command from " + socket);
            try {
                String string = socket.getInetAddress().getHostAddress();
                if (!string.equals("localhost") && !string.equals(NetworkUtil.LOOPBACK_LOCALHOST_IPv4)) continue;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), ENCODING));
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    this.logFine("Did not receive valid remote request");
                    continue;
                }
                if (string2.startsWith(REMOTECOMMAND_PREFIX)) {
                    this.processCommand(string2.substring(REMOTECOMMAND_PREFIX.length() + 1));
                    continue;
                }
                if (string2.startsWith("GET") || string2.startsWith("POST")) {
                    this.processWebRequest(string2, socket.getOutputStream());
                    continue;
                }
                this.logWarning("Unknown remote command: " + string2);
            }
            catch (Exception exception) {
                this.logWarning("Problems parsing remote command from " + socket + ". " + exception);
                this.logFiner(exception);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebRequest(String string, OutputStream outputStream) throws IOException {
        this.logFine("Received request: " + string);
        String string2 = null;
        if (string.startsWith("GET ") && string.contains("/login?Token=")) {
            int n = string.indexOf("/login?Token=") + "/login?Token=".length();
            int n2 = string.indexOf(" ", n);
            if (n > "/login?Token=".length() - 1 && n2 > n) {
                string2 = string.substring(n, n2);
                this.logFine("Retrieved and extracted Token from web request: " + string2);
            }
        }
        try {
            if (string2 != null) {
                if (this.getController().isUIEnabled()) {
                    this.getController().getUIController().getAgreeToSListener().setAutoOpenBrowser(false);
                }
                if (this.getController().getOSClient().isKeepLoggedIn()) {
                    ConfigurationEntry.SERVER_CONNECT_TOKEN.setValue(this.getController(), string2);
                } else {
                    ConfigurationEntry.SERVER_CONNECT_TOKEN.removeValue(this.getController());
                }
                this.getController().saveConfig();
                if (this.getController().getOSClient().login(string2).isValid()) {
                    ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.removeValue(this.getController());
                    ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.removeValue(this.getController());
                    this.getController().saveConfig();
                    String string3 = "/login?success=true";
                    if (this.getController().getOSClient().getAccountDetails().needsToAgreeToS()) {
                        string3 = this.getController().getOSClient().getLoginURLWithCredentials();
                    }
                    RemoteCommandManager.redirectLoginSuccess(outputStream, string3);
                } else {
                    RemoteCommandManager.loginFailed(outputStream);
                }
            } else if (string.startsWith("GET ") && string.contains("/login?success=true")) {
                RemoteCommandManager.loginSuccess(outputStream);
            } else {
                RemoteCommandManager.loginFailed(outputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logWarning(runtimeException);
            RemoteCommandManager.loginFailed(outputStream);
        }
        finally {
            if (this.getController().isUIEnabled()) {
                this.getController().getUIController().getAgreeToSListener().setAutoOpenBrowser(true);
            }
            outputStream.close();
        }
    }

    private static void redirectLoginSuccess(OutputStream outputStream, String string) throws IOException {
        String string2 = "HTTP/1.1 302 Found\r\nLocation: " + string + "\r\nConnection: close\r\n\r\n";
        outputStream.write(string2.getBytes(StandardCharsets.UTF_8));
    }

    private static void loginSuccess(OutputStream outputStream) throws IOException {
        String string = "<html><body>" + Translation.get("login.saml.browser_success") + "</body></html>";
        String string2 = "HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: " + string.length() + "\r\nConnection: close\r\n\r\n" + string;
        outputStream.write(string2.getBytes(StandardCharsets.UTF_8));
    }

    private static void loginFailed(OutputStream outputStream) throws IOException {
        String string = "<html><body>" + Translation.get("login.saml.browser_failed") + "</body></html>";
        String string2 = "HTTP/1.1 400 Bad Request\r\nContent-Type: text/html; charset=UTF-8\r\nContent-Length: " + string.length() + "\r\nConnection: close\r\n\r\n" + string;
        outputStream.write(string2.getBytes(StandardCharsets.UTF_8));
    }

    private void processCommand(String string) {
        Object object;
        if (StringUtils.isBlank(string)) {
            log.severe("Received a empty remote command");
            return;
        }
        this.logFine("Processing remote command: '" + string + "'");
        if (string.startsWith(MAKEFOLDER) || string.startsWith(COPYLINK)) {
            object = new Waiter(60000L);
            while (!((Waiter)object).isTimeout() && !this.getController().getOSClient().isLoggedIn() && Feature.OS_CLIENT.isEnabled()) {
                ((Waiter)object).waitABit();
            }
        }
        if (QUIT.equalsIgnoreCase(string)) {
            this.getController().exit(0);
        }
        if (RELOAD_CONFIG.equalsIgnoreCase(string)) {
            this.getController().reloadConfigFile();
        } else if (string.startsWith(OPEN)) {
            object = string.substring(OPEN.length());
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Path path = Paths.get(string2, new String[0]).toAbsolutePath();
                this.openFile(path);
            }
        } else if (string.startsWith(SHOW_UI)) {
            if (this.getController().isUIEnabled()) {
                this.getController().getUIController().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemoteCommandManager.this.getController().getUIController().getMainFrame().toFront();
                    }
                });
            }
        } else if (string.startsWith(MAKEFOLDER)) {
            boolean bl;
            object = string.substring(MAKEFOLDER.length());
            if (this.getController().isUIOpen()) {
                this.getController().getUIController().getMainFrame().getUIComponent().setVisible(true);
                this.getController().getUIController().getMainFrame().getUIComponent().setExtendedState(0);
            }
            boolean bl2 = bl = !((String)object).contains("dir=");
            if (bl) {
                this.logWarning("Converted old style folder make command for directory " + (String)object);
                object = "dir=" + (String)object;
            }
            Object object2 = object;
            this.getController().schedule(new Runnable(){
                final /* synthetic */ String val$finalFolderConfig;
                {
                    this.val$finalFolderConfig = string;
                }

                @Override
                public void run() {
                    RemoteCommandManager.this.makeFolder(this.val$finalFolderConfig);
                }
            }, 0L);
        } else if (string.startsWith(REMOVEFOLDER)) {
            object = string.substring(REMOVEFOLDER.length());
            this.getController().schedule(new Runnable(){
                final /* synthetic */ String val$folderConfig;
                {
                    this.val$folderConfig = string;
                }

                @Override
                public void run() {
                    RemoteCommandManager.this.removeFolder(this.val$folderConfig);
                }
            }, 0L);
        } else if (string.startsWith(COPYLINK)) {
            object = string.substring(COPYLINK.length());
            this.getController().schedule(new Runnable(){
                final /* synthetic */ String val$filename;
                {
                    this.val$filename = string;
                }

                @Override
                public void run() {
                    RemoteCommandManager.this.copyLink(this.val$filename);
                }
            }, 0L);
        } else {
            log.warning("Remote command not recognizable '" + string + "'");
        }
    }

    protected void copyLink(String string) {
        Path path = Paths.get(string, new String[0]).toAbsolutePath();
        String string2 = path.toString();
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (!string2.startsWith(folder.getLocalBase().toAbsolutePath().toString())) continue;
            final ServerClient serverClient = this.getController().getOSClient();
            final FileInfo fileInfo = FileInfoFactory.lookupInstance(folder, path);
            if (serverClient.isConnected()) {
                this.getController().getIOProvider().startIO(new Runnable(){

                    @Override
                    public void run() {
                        String string = serverClient.getFolderService(fileInfo.getFolderInfo()).getFileLink(fileInfo);
                        Util.setClipboardContents(string);
                    }
                });
            }
            BrowserLauncher.open(this.getController(), new BrowserLauncher.URLProducer(){

                @Override
                public String url() {
                    return serverClient.getFileLinkURLWithCredentials(fileInfo);
                }
            });
            return;
        }
        this.logWarning("Unable to copy file link. File not contained in a shared folder");
        if (this.getController().isUIEnabled()) {
            this.getController().getUIController().getMainFrame().toFront();
            DialogFactory.genericDialog(this.getController(), Translation.get("remote_command_manager.copy_link.error_title"), Translation.get("remote_command_manager.copy_link.error_message", string), GenericDialogType.ERROR);
        }
    }

    private void openFile(Path path) {
        MemberInfo[] memberInfoArray;
        if (Files.notExists(path, new LinkOption[0])) {
            log.warning("File not found " + path.toAbsolutePath().toString());
            return;
        }
        if (path.getFileName().toString().endsWith(".nodes") && (memberInfoArray = RemoteCommandManager.loadNodesFile(path)) != null) {
            this.getController().getNodeManager().queueNewNodes(memberInfoArray);
        }
    }

    private void removeFolder(String string) {
        Map<String, String> map = this.parseFolderConfig(string);
        String string2 = map.get(FOLDER_SCRIPT_CONFIG_ID);
        String string3 = map.get(FOLDER_SCRIPT_CONFIG_NAME);
        String string4 = map.get(FOLDER_SCRIPT_CONFIG_DIR);
        Path path = StringUtils.isBlank(string4) ? null : Paths.get(string4, new String[0]);
        this.logFine("Remove folder command received. Config: " + string);
        if (StringUtils.isBlank(string2) && StringUtils.isBlank(string3) && path == null) {
            this.logSevere("Unable to remove folder. Wrong parameters: " + string);
            return;
        }
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (StringUtils.isNotBlank(string2) && !folder.getId().equals(string2) || StringUtils.isNotBlank(string3) && !folder.getName().equalsIgnoreCase(string3)) continue;
            if (path != null) {
                try {
                    if (!folder.getLocalBase().equals(path) && !folder.getLocalBase().toRealPath(new LinkOption[0]).equals(path.toRealPath(new LinkOption[0]))) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    this.logWarning("Unable to check by directory: " + folder + ". Dir: " + path + ". " + exception, exception);
                }
            }
            this.logInfo("Removing folder: " + folder + ". Matched by: " + string);
            this.getController().getFolderRepository().removeFolder(folder, true);
        }
    }

    private void makeFolder(String string) {
        Object object;
        Map<String, String> map = this.parseFolderConfig(string);
        if (StringUtils.isBlank(map.get(FOLDER_SCRIPT_CONFIG_DIR))) {
            this.logSevere("Unable to parse make folder command. directory missing. " + string);
            return;
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Path path = Paths.get(map.get(FOLDER_SCRIPT_CONFIG_DIR), new String[0]);
        String string2 = StringUtils.isNotBlank(map.get(FOLDER_SCRIPT_CONFIG_NAME)) ? map.get(FOLDER_SCRIPT_CONFIG_NAME) : PathUtils.getSuggestedFolderName(path);
        path = PathUtils.removeInvalidFilenameChars(path);
        if (!this.getController().getOSClient().isAllowedToCreateFolders()) {
            if (this.getController().isUIEnabled()) {
                this.getController().getUIController().getMainFrame().toFront();
                DialogFactory.genericDialog(this.getController(), Translation.get("remote_command_manager.make_folder.error_title"), Translation.get("remote_command_manager.make_folder.error_message", string2), GenericDialogType.ERROR);
            }
            return;
        }
        boolean bl = "true".equalsIgnoreCase(map.get(FOLDER_SCRIPT_CONFIG_SILENT));
        String string3 = map.get(FOLDER_SCRIPT_CONFIG_ID);
        if (ConfigurationEntry.FOLDER_CREATE_AVOID_DUPES.getValueBoolean(this.getController()).booleanValue()) {
            object = folderRepository.findExistingFolder(path);
            if (object != null) {
                object = folderRepository.findExistingFolder(string2);
            }
            if (object != null) {
                string3 = ((Folder)object).getId();
                this.logWarning("Deleting folder: " + (Folder)object + " at " + ((Folder)object).getLocalBase() + ". Replacing it new one at " + path);
                folderRepository.removeFolder((Folder)object, true);
            }
        }
        SyncProfile syncProfile = (object = map.get(FOLDER_SCRIPT_CONFIG_SYNC_PROFILE)) != null ? SyncProfile.getSyncProfileByFieldList((String)object) : null;
        boolean bl2 = "true".equals(map.get(FOLDER_SCRIPT_CONFIG_BACKUP_BY_SERVER));
        FolderInfo folderInfo = StringUtils.isBlank(string3) ? FolderInfoFactory.newTopFolder(string2) : FolderInfoFactory.newTopFolder(string3, string2);
        String string4 = map.get(FOLDER_SCRIPT_CONFIG_DL_SCRIPT);
        if (!bl && this.getController().isUIEnabled()) {
            PFWizard pFWizard = new PFWizard(this.getController(), Translation.get("wizard.pfwizard.folder_title"));
            pFWizard.getWizardContext().setAttribute("disklocation.initial_folder_name", string2);
            if (syncProfile != null) {
                pFWizard.getWizardContext().setAttribute("disklocation.sync_profile", syncProfile);
            }
            pFWizard.getWizardContext().setAttribute("folder_create.backup_by_os", bl2 || StringUtils.isBlank(map.get(FOLDER_SCRIPT_CONFIG_BACKUP_BY_SERVER)));
            pFWizard.getWizardContext().setAttribute("disklocation.folder_info", folderInfo);
            FolderCreatePanel folderCreatePanel = new FolderCreatePanel(this.getController());
            TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
            pFWizard.getWizardContext().setAttribute("successpanel", textPanelPanel);
            ChooseDiskLocationPanel chooseDiskLocationPanel = new ChooseDiskLocationPanel(this.getController(), path.toAbsolutePath().toString(), folderCreatePanel);
            pFWizard.open(chooseDiskLocationPanel);
        } else {
            if (syncProfile == null) {
                syncProfile = SyncProfile.getDefault(this.getController());
            }
            FolderSettings folderSettings = new FolderSettings(path, syncProfile, string4, ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()), true);
            folderRepository.createFolder(folderInfo, folderSettings);
            if (bl2) {
                new CreateFolderOnServerTask(folderInfo, null).scheduleTask(this.getController());
            }
        }
    }

    private Map<String, String> parseFolderConfig(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= 0) {
                this.logSevere("Unable to parse make folder command: '" + string + "'");
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static MemberInfo[] loadNodesFile(Path path) {
        block8: {
            MemberInfo[] memberInfoArray;
            ObjectInputStream objectInputStream = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                List list = (List)objectInputStream.readObject();
                log.warning("Loaded " + list.size() + " nodes");
                MemberInfo[] memberInfoArray2 = new MemberInfo[list.size()];
                list.toArray(memberInfoArray2);
                memberInfoArray = memberInfoArray2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        objectInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.log(Level.SEVERE, "Unable to load nodes from file '" + path + "'.", iOException);
                    break block8;
                }
                catch (ClassCastException | ClassNotFoundException exception) {
                    log.log(Level.SEVERE, "Illegal format of nodes file '" + path + "'.", exception);
                }
            }
            objectInputStream.close();
            return memberInfoArray;
        }
        return null;
    }
}

