/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;

public abstract class ProducerMonitor {
    private static final ProducerMonitor NO_OP = new ProducerMonitor(){

        @Override
        public <T> void addCallbackTo(ListenableFuture<T> listenableFuture) {
        }
    };

    public void requested() {
    }

    public void ready() {
    }

    public void methodStarting() {
    }

    public void methodFinished() {
    }

    public void succeeded(Object object) {
    }

    public void failed(Throwable throwable) {
    }

    public <T> void addCallbackTo(ListenableFuture<T> listenableFuture) {
        Futures.addCallback(listenableFuture, new FutureCallback<T>(){

            @Override
            public void onSuccess(T t) {
                ProducerMonitor.this.succeeded(t);
            }

            @Override
            public void onFailure(Throwable throwable) {
                ProducerMonitor.this.failed(throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    public static ProducerMonitor noOp() {
        return NO_OP;
    }
}

