/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JDateChooser
extends JPanel
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    protected JButton calendarButton;
    protected JSpinner dateSpinner;
    protected JSpinner.DateEditor editor;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected SpinnerDateModel model;
    protected String dateFormatString;
    protected boolean dateSelected;
    protected boolean isInitialized;
    protected Date lastSelectedDate;
    protected boolean startEmpty;

    public JDateChooser() {
        this(null, null, false, null);
    }

    public JDateChooser(ImageIcon imageIcon) {
        this(null, null, false, imageIcon);
    }

    public JDateChooser(boolean bl) {
        this(null, null, bl, null);
    }

    public JDateChooser(String string, boolean bl) {
        this(null, string, bl, null);
    }

    public JDateChooser(JCalendar jCalendar) {
        this(jCalendar, null, false, null);
    }

    public JDateChooser(JCalendar jCalendar, String string, boolean bl, ImageIcon imageIcon) {
        if (jCalendar == null) {
            jCalendar = new JCalendar();
        }
        this.jcalendar = jCalendar;
        if (string == null) {
            string = "MMMMM d, yyyy";
        }
        this.dateFormatString = string;
        this.startEmpty = bl;
        this.setLayout(new BorderLayout());
        jCalendar.getDayChooser().addPropertyChangeListener(this);
        jCalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.model = new SpinnerDateModel();
        this.setModel(this.model);
        this.dateSpinner = new JSpinner(this.model){

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                JDateChooser.this.calendarButton.setEnabled(bl);
            }
        };
        String string2 = "";
        if (!bl) {
            string2 = string;
        }
        this.editor = new JSpinner.DateEditor(this.dateSpinner, string2);
        this.dateSpinner.setEditor(this.editor);
        this.add((Component)this.dateSpinner, "Center");
        if (imageIcon == null) {
            URL uRL = this.getClass().getResource("images/JDateChooserIcon.gif");
            imageIcon = new ImageIcon(uRL);
        }
        this.calendarButton = new JButton(imageIcon);
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.calendarButton.addActionListener(this);
        this.calendarButton.setMnemonic(67);
        this.add((Component)this.calendarButton, "East");
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                Boolean bl2 = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (bl || !bl && JDateChooser.this.dateSelected || bl2 != null && !bl && bl2.booleanValue()) {
                    super.setVisible(bl);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add(jCalendar);
        this.lastSelectedDate = this.model.getDate();
        this.isInitialized = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.calendarButton.getWidth() - (int)this.popup.getPreferredSize().getWidth();
        int n2 = this.calendarButton.getY() + this.calendarButton.getHeight();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.model.getDate());
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.calendarButton, n, n2);
        this.dateSelected = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.setDate(this.jcalendar.getCalendar().getTime());
            this.setDateFormatString(this.dateFormatString);
        } else if (propertyChangeEvent.getPropertyName().equals("date")) {
            this.setDate((Date)propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.jcalendar != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        this.dateSpinner.setLocale(locale);
        this.editor = new JSpinner.DateEditor(this.dateSpinner, this.dateFormatString);
        this.dateSpinner.setEditor(this.editor);
        this.jcalendar.setLocale(locale);
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public void setDateFormatString(String string) {
        this.dateFormatString = string;
        this.editor.getFormat().applyPattern(string);
        this.invalidate();
    }

    @Override
    public String getName() {
        return "JDateChooser";
    }

    public Date getDate() {
        return this.model.getDate();
    }

    public void setDate(Date date) {
        this.model.setValue(date);
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isInitialized) {
            this.firePropertyChange("date", this.lastSelectedDate, this.model.getDate());
            this.lastSelectedDate = this.model.getDate();
        }
    }

    public JSpinner getSpinner() {
        return this.dateSpinner;
    }

    public SpinnerDateModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerDateModel spinnerDateModel) {
        this.model = spinnerDateModel;
        this.model.setCalendarField(4);
        this.model.addChangeListener(this);
        if (this.dateSpinner != null) {
            this.dateSpinner.setModel(this.model);
        }
    }
}

