/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;

public class ValidationResultModelContainer
extends DefaultValidationResultModel {
    public static final String PROPERTYNAME_EXPANDED = "expanded";
    private final ValidationMessage collapsedMessage;
    private boolean expanded;
    private final List<ValidationResultModel> childResultModels;
    private final PropertyChangeListener childResultUpdateHandler;

    public ValidationResultModelContainer(ValidationMessage validationMessage) {
        this.collapsedMessage = validationMessage;
        this.childResultModels = new LinkedList<ValidationResultModel>();
        this.expanded = true;
        this.childResultUpdateHandler = new ChildResultUpdateHandler();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        boolean bl2 = this.isExpanded();
        this.expanded = bl;
        this.updateContainerResult();
        this.firePropertyChange(PROPERTYNAME_EXPANDED, bl2, bl);
    }

    public ValidationResult getCollapsedValidationResult() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.add(this.collapsedMessage);
        return validationResult;
    }

    public ValidationResult getExpandedValidationResult() {
        ValidationResult validationResult = new ValidationResult();
        for (ValidationResultModel validationResultModel : this.childResultModels) {
            validationResult.addAllFrom(validationResultModel.getResult());
        }
        return validationResult;
    }

    public void add(ValidationResultModel validationResultModel) {
        this.childResultModels.add(validationResultModel);
        validationResultModel.addPropertyChangeListener("result", this.childResultUpdateHandler);
    }

    public void remove(ValidationResultModel validationResultModel) {
        this.childResultModels.remove(validationResultModel);
        validationResultModel.removePropertyChangeListener("result", this.childResultUpdateHandler);
    }

    public final void setResult(ValidationResult validationResult) {
        throw new UnsupportedOperationException("Cannot set a validation result for ValidationResultModelContainer. The result will be computed from the contained results instead.");
    }

    private void updateContainerResult() {
        ValidationResult validationResult = this.isExpanded() ? this.getExpandedValidationResult() : this.getCollapsedValidationResult();
        super.setResult(validationResult);
    }

    private final class ChildResultUpdateHandler
    implements PropertyChangeListener {
        private ChildResultUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ValidationResultModelContainer.this.updateContainerResult();
        }
    }
}

