/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ComponentValueModel
extends AbstractValueModel {
    public static final String PROPERTYNAME_ENABLED = "enabled";
    public static final String PROPERTYNAME_VISIBLE = "visible";
    public static final String PROPERTYNAME_EDITABLE = "editable";
    private final ValueModel subject;
    private boolean enabled;
    private boolean visible;
    private boolean editable;

    public ComponentValueModel(ValueModel valueModel) {
        this.subject = valueModel;
        this.enabled = true;
        this.editable = true;
        this.visible = true;
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
    }

    public Object getValue() {
        return this.subject.getValue();
    }

    public void setValue(Object object) {
        this.subject.setValue(object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        this.enabled = bl;
        this.firePropertyChange(PROPERTYNAME_ENABLED, bl2, bl);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this.visible = bl;
        this.firePropertyChange(PROPERTYNAME_VISIBLE, bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        this.editable = bl;
        this.firePropertyChange(PROPERTYNAME_EDITABLE, bl2, bl);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentValueModel.this.fireValueChange(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
        }
    }
}

