/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.beans.BeanUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtils {
    private static final Logger LOGGER = Logger.getLogger(LoggingUtils.class.getName());
    private static Level defaultLevel = Level.FINE;

    private LoggingUtils() {
    }

    public static void setDefaultLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("The log level must not be null.");
        }
        defaultLevel = level;
    }

    public static void logPropertyChanges(Object object) {
        LoggingUtils.logPropertyChanges(object, LOGGER);
    }

    public static void logPropertyChanges(Object object, Logger logger) {
        LoggingUtils.logPropertyChanges(object, logger, defaultLevel);
    }

    public static void logPropertyChanges(Object object, Logger logger, Level level) {
        BeanUtils.addPropertyChangeListener(object, new LogHandler(logger, level));
    }

    public static void logPropertyChanges(Object object, String string) {
        LoggingUtils.logPropertyChanges(object, string, LOGGER);
    }

    public static void logPropertyChanges(Object object, String string, Logger logger) {
        LoggingUtils.logPropertyChanges(object, string, logger, defaultLevel);
    }

    public static void logPropertyChanges(Object object, String string, Logger logger, Level level) {
        BeanUtils.addPropertyChangeListener(object, string, (PropertyChangeListener)new LogHandler(logger, level));
    }

    private static final class LogHandler
    implements PropertyChangeListener {
        private final Logger logger;
        private final Level level;

        LogHandler(Logger logger, Level level) {
            if (logger == null) {
                throw new NullPointerException("The logger must not be null.");
            }
            if (level == null) {
                throw new NullPointerException("The level must not be null.");
            }
            this.logger = logger;
            this.level = level;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.logger.isLoggable(this.level)) {
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            StringBuilder stringBuilder = new StringBuilder(propertyChangeEvent.getSource().toString());
            stringBuilder.append(" [propertyName=");
            stringBuilder.append(propertyChangeEvent.getPropertyName());
            stringBuilder.append(", oldValue=");
            stringBuilder.append(object2);
            if (object2 != null) {
                stringBuilder.append(", oldValueType=");
                stringBuilder.append(object2.getClass());
            }
            stringBuilder.append(", newValue=");
            stringBuilder.append(object);
            if (object != null) {
                stringBuilder.append(", newValueType=");
                stringBuilder.append(object.getClass());
            }
            this.logger.log(this.level, stringBuilder.toString());
        }
    }
}

