/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ObservableList;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayListModel<E>
extends ArrayList<E>
implements ObservableList<E> {
    private static final long serialVersionUID = -6165677201152015546L;
    private EventListenerList listenerList;

    public ArrayListModel() {
        this(10);
    }

    public ArrayListModel(int n) {
        super(n);
    }

    public ArrayListModel(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        this.fireIntervalAdded(n, n);
    }

    @Override
    public boolean add(E e) {
        int n = this.size();
        super.add(e);
        this.fireIntervalAdded(n, n);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = super.addAll(n, collection);
        if (bl) {
            int n2 = n + collection.size() - 1;
            this.fireIntervalAdded(n, n2);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n = this.size();
        boolean bl = super.addAll(collection);
        if (bl) {
            int n2 = n + collection.size() - 1;
            this.fireIntervalAdded(n, n2);
        }
        return bl;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int n = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, n);
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        this.fireIntervalRemoved(n, n);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl;
        int n = this.indexOf(object);
        boolean bl2 = bl = n != -1;
        if (bl) {
            this.remove(n);
        }
        return bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        super.removeRange(n, n2);
        this.fireIntervalRemoved(n, n2 - 1);
    }

    @Override
    public E set(int n, E e) {
        E e2 = super.set(n, e);
        this.fireContentsChanged(n, n);
        return e2;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().add(ListDataListener.class, listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().remove(ListDataListener.class, listDataListener);
    }

    public Object getElementAt(int n) {
        return this.get(n);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public void fireContentsChanged(int n) {
        this.fireContentsChanged(n, n);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getEventListenerList().getListeners(ListDataListener.class);
    }

    private void fireContentsChanged(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    private void fireIntervalAdded(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    private void fireIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }
}

