/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import com.jgoodies.binding.value.ValueModel;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyConnector {
    private final Object bean1;
    private final Object bean2;
    private final Class<?> bean1Class;
    private final Class<?> bean2Class;
    private final String property1Name;
    private final String property2Name;
    private final PropertyChangeListener property1ChangeHandler;
    private final PropertyChangeListener property2ChangeHandler;
    private final PropertyDescriptor property1Descriptor;
    private final PropertyDescriptor property2Descriptor;

    private PropertyConnector(Object object, String string, Object object2, String string2) {
        boolean bl;
        boolean bl2;
        if (object == null) {
            throw new NullPointerException("Bean1 must not be null.");
        }
        if (object2 == null) {
            throw new NullPointerException("Bean2 must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("PropertyName1 must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("PropertyName2 must not be null.");
        }
        if (object == object2 && string.equals(string2)) {
            throw new IllegalArgumentException("Cannot connect a bean property to itself on the same bean.");
        }
        this.bean1 = object;
        this.bean2 = object2;
        this.bean1Class = object.getClass();
        this.bean2Class = object2.getClass();
        this.property1Name = string;
        this.property2Name = string2;
        this.property1Descriptor = PropertyConnector.getPropertyDescriptor(this.bean1Class, string);
        this.property2Descriptor = PropertyConnector.getPropertyDescriptor(this.bean2Class, string2);
        boolean bl3 = this.property1Descriptor.getWriteMethod() != null;
        boolean bl4 = bl2 = this.property1Descriptor.getReadMethod() != null;
        if (bl3 && !bl2) {
            throw new IllegalArgumentException("Property1 must be readable.");
        }
        boolean bl5 = this.property2Descriptor.getWriteMethod() != null;
        boolean bl6 = bl = this.property2Descriptor.getReadMethod() != null;
        if (bl5 && !bl) {
            throw new IllegalArgumentException("Property2 must be readable.");
        }
        if (!bl3 && !bl5) {
            throw new IllegalArgumentException("Cannot connect two read-only properties.");
        }
        boolean bl7 = BeanUtils.supportsBoundProperties(this.bean1Class);
        boolean bl8 = BeanUtils.supportsBoundProperties(this.bean2Class);
        if (bl7 && bl5) {
            this.property1ChangeHandler = new PropertyChangeHandler(object, this.property1Descriptor, object2, this.property2Descriptor);
            PropertyConnector.addPropertyChangeHandler(object, this.bean1Class, this.property1ChangeHandler);
        } else {
            this.property1ChangeHandler = null;
        }
        if (bl8 && bl3) {
            this.property2ChangeHandler = new PropertyChangeHandler(object2, this.property2Descriptor, object, this.property1Descriptor);
            PropertyConnector.addPropertyChangeHandler(object2, this.bean2Class, this.property2ChangeHandler);
        } else {
            this.property2ChangeHandler = null;
        }
    }

    public static PropertyConnector connect(Object object, String string, Object object2, String string2) {
        return new PropertyConnector(object, string, object2, string2);
    }

    public static void connectAndUpdate(ValueModel valueModel, Object object, String string) {
        PropertyConnector propertyConnector = new PropertyConnector(valueModel, "value", object, string);
        propertyConnector.updateProperty2();
    }

    public Object getBean1() {
        return this.bean1;
    }

    public Object getBean2() {
        return this.bean2;
    }

    public String getProperty1Name() {
        return this.property1Name;
    }

    public String getProperty2Name() {
        return this.property2Name;
    }

    public void updateProperty1() {
        Object object = BeanUtils.getValue(this.bean2, this.property2Descriptor);
        this.setValueSilently(this.bean2, this.property2Descriptor, this.bean1, this.property1Descriptor, object);
    }

    public void updateProperty2() {
        Object object = BeanUtils.getValue(this.bean1, this.property1Descriptor);
        this.setValueSilently(this.bean1, this.property1Descriptor, this.bean2, this.property2Descriptor, object);
    }

    public void release() {
        PropertyConnector.removePropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        PropertyConnector.removePropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
    }

    private static void addPropertyChangeHandler(Object object, Class<?> clazz, PropertyChangeListener propertyChangeListener) {
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, clazz, propertyChangeListener);
        }
    }

    private static void removePropertyChangeHandler(Object object, Class<?> clazz, PropertyChangeListener propertyChangeListener) {
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, clazz, propertyChangeListener);
        }
    }

    private void setValueSilently(Object object, PropertyDescriptor propertyDescriptor, Object object2, PropertyDescriptor propertyDescriptor2, Object object3) {
        Object object4 = BeanUtils.getValue(object2, propertyDescriptor2);
        if (object4 == object3) {
            return;
        }
        if (this.property1ChangeHandler != null) {
            PropertyConnector.removePropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        }
        if (this.property2ChangeHandler != null) {
            PropertyConnector.removePropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
        }
        try {
            BeanUtils.setValue(object2, propertyDescriptor2, object3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        object4 = BeanUtils.getValue(object2, propertyDescriptor2);
        if (!BindingUtils.equals(object4, object3)) {
            boolean bl;
            boolean bl2 = bl = propertyDescriptor.getWriteMethod() != null;
            if (bl) {
                try {
                    BeanUtils.setValue(object, propertyDescriptor, object4);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        if (this.property1ChangeHandler != null) {
            PropertyConnector.addPropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        }
        if (this.property2ChangeHandler != null) {
            PropertyConnector.addPropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String string) {
        try {
            return BeanUtils.getPropertyDescriptor(clazz, string);
        }
        catch (IntrospectionException introspectionException) {
            throw new PropertyNotFoundException(string, clazz, (Throwable)introspectionException);
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private final Object sourceBean;
        private final PropertyDescriptor sourcePropertyDescriptor;
        private final Object targetBean;
        private final PropertyDescriptor targetPropertyDescriptor;

        private PropertyChangeHandler(Object object, PropertyDescriptor propertyDescriptor, Object object2, PropertyDescriptor propertyDescriptor2) {
            this.sourceBean = object;
            this.sourcePropertyDescriptor = propertyDescriptor;
            this.targetBean = object2;
            this.targetPropertyDescriptor = propertyDescriptor2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = this.sourcePropertyDescriptor.getName();
            String string2 = propertyChangeEvent.getPropertyName();
            if (string2 == null || string2.equals(string)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null || string2 == null) {
                    object = BeanUtils.getValue(this.sourceBean, this.sourcePropertyDescriptor);
                }
                PropertyConnector.this.setValueSilently(this.sourceBean, this.sourcePropertyDescriptor, this.targetBean, this.targetPropertyDescriptor, object);
            }
        }
    }
}

