/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAccessException;
import com.jgoodies.binding.beans.PropertyNotBindableException;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import com.jgoodies.binding.beans.PropertyUnboundException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanUtils {
    private static final Class<?>[] PCL_PARAMS = new Class[]{PropertyChangeListener.class};
    private static final Class<?>[] NAMED_PCL_PARAMS = new Class[]{String.class, PropertyChangeListener.class};

    private BeanUtils() {
    }

    public static boolean supportsBoundProperties(Class<?> clazz) {
        return BeanUtils.getPCLAdder(clazz) != null && BeanUtils.getPCLRemover(clazz) != null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new IntrospectionException("Property '" + string + "' not found in bean " + clazz);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String string, String string2, String string3) {
        try {
            return string2 != null || string3 != null ? new PropertyDescriptor(string, clazz, string2, string3) : BeanUtils.getPropertyDescriptor(clazz, string);
        }
        catch (IntrospectionException introspectionException) {
            throw new PropertyNotFoundException(string, clazz, (Throwable)introspectionException);
        }
    }

    public static Method getPCLAdder(Class<?> clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getPCLRemover(Class<?> clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getNamedPCLAdder(Class<?> clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getNamedPCLRemover(Class<?> clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void addPropertyChangeListener(Object object, Class<?> clazz, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        if (clazz == null) {
            clazz = object.getClass();
        } else if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The bean " + object + " must be an instance of " + clazz);
        }
        if (object instanceof Model) {
            ((Model)object).addPropertyChangeListener(propertyChangeListener);
            return;
        }
        if (!BeanUtils.supportsBoundProperties(clazz)) {
            throw new PropertyUnboundException("Bound properties unsupported by bean class=" + clazz + "\nThe Bean class must provide a pair of methods:" + "\npublic void addPropertyChangeListener(PropertyChangeListener x);" + "\npublic void removePropertyChangeListener(PropertyChangeListener x);");
        }
        Method method = BeanUtils.getPCLAdder(clazz);
        try {
            method.invoke(object, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a multicast PropertyChangeListener to bean: " + object, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a multicast PropertyChangeListener to bean: " + object, illegalAccessException);
        }
    }

    public static void addPropertyChangeListener(Object object, Class<?> clazz, String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        if (clazz == null) {
            clazz = object.getClass();
        } else if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The bean " + object + " must be an instance of " + clazz);
        }
        if (object instanceof Model) {
            ((Model)object).addPropertyChangeListener(string, propertyChangeListener);
            return;
        }
        Method method = BeanUtils.getNamedPCLAdder(clazz);
        if (method == null) {
            throw new PropertyNotBindableException("Could not find the bean method/npublic void addPropertyChangeListener(String, PropertyChangeListener);/nin bean:" + object);
        }
        try {
            method.invoke(object, string, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a named PropertyChangeListener to bean: " + object, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a named PropertyChangeListener to bean: " + object, illegalAccessException);
        }
    }

    public static void addPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        BeanUtils.addPropertyChangeListener(object, object.getClass(), propertyChangeListener);
    }

    public static void addPropertyChangeListener(Object object, String string, PropertyChangeListener propertyChangeListener) {
        BeanUtils.addPropertyChangeListener(object, object.getClass(), string, propertyChangeListener);
    }

    public static void removePropertyChangeListener(Object object, Class<?> clazz, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        if (clazz == null) {
            clazz = object.getClass();
        } else if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The bean " + object + " must be an instance of " + clazz);
        }
        if (object instanceof Model) {
            ((Model)object).removePropertyChangeListener(propertyChangeListener);
            return;
        }
        Method method = BeanUtils.getPCLRemover(clazz);
        if (method == null) {
            throw new PropertyUnboundException("Could not find the method:\npublic void removePropertyChangeListener(String, PropertyChangeListener x);\nfor bean:" + object);
        }
        try {
            method.invoke(object, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a multicast PropertyChangeListener from bean: " + object, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a multicast PropertyChangeListener from bean: " + object, illegalAccessException);
        }
    }

    public static void removePropertyChangeListener(Object object, Class<?> clazz, String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        if (clazz == null) {
            clazz = object.getClass();
        } else if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The bean " + object + " must be an instance of " + clazz);
        }
        if (object instanceof Model) {
            ((Model)object).removePropertyChangeListener(string, propertyChangeListener);
            return;
        }
        Method method = BeanUtils.getNamedPCLRemover(clazz);
        if (method == null) {
            throw new PropertyNotBindableException("Could not find the bean method/npublic void removePropertyChangeListener(String, PropertyChangeListener);/nin bean:" + object);
        }
        try {
            method.invoke(object, string, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a named PropertyChangeListener from bean: " + object, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a named PropertyChangeListener from bean: " + object, illegalAccessException);
        }
    }

    public static void removePropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        BeanUtils.removePropertyChangeListener(object, object.getClass(), propertyChangeListener);
    }

    public static void removePropertyChangeListener(Object object, String string, PropertyChangeListener propertyChangeListener) {
        BeanUtils.removePropertyChangeListener(object, object.getClass(), string, propertyChangeListener);
    }

    public static Object getValue(Object object, PropertyDescriptor propertyDescriptor) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new UnsupportedOperationException("The property '" + propertyDescriptor.getName() + "' is write-only.");
        }
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw PropertyAccessException.createReadAccessException(object, propertyDescriptor, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw PropertyAccessException.createReadAccessException(object, propertyDescriptor, illegalAccessException);
        }
    }

    public static void setValue(Object object, PropertyDescriptor propertyDescriptor, Object object2) throws PropertyVetoException {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new UnsupportedOperationException("The property '" + propertyDescriptor.getName() + "' is read-only.");
        }
        try {
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof PropertyVetoException) {
                throw (PropertyVetoException)throwable;
            }
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, illegalArgumentException);
        }
    }
}

