/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public final class ColorSelectionAdapter
extends DefaultColorSelectionModel {
    private final ValueModel subject;
    private final Color defaultColor;

    public ColorSelectionAdapter(ValueModel valueModel) {
        this(valueModel, null);
    }

    public ColorSelectionAdapter(ValueModel valueModel, Color color) {
        if (valueModel == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        this.subject = valueModel;
        this.defaultColor = color;
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
    }

    public Color getSelectedColor() {
        Color color = (Color)this.subject.getValue();
        return color != null ? color : this.defaultColor;
    }

    public void setSelectedColor(Color color) {
        this.subject.setValue(color);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ColorSelectionAdapter.this.fireStateChanged();
        }
    }
}

