/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsArrayTypeSerializer
extends TypeSerializerBase {
    public AsArrayTypeSerializer(TypeIdResolver typeIdResolver, BeanProperty beanProperty) {
        super(typeIdResolver, beanProperty);
    }

    @Override
    public AsArrayTypeSerializer forProperty(BeanProperty beanProperty) {
        return this._property == beanProperty ? this : new AsArrayTypeSerializer(this._idResolver, beanProperty);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        String string = this.idFromValue(object);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartObject();
    }

    @Override
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        String string = this.idFromValueAndType(object, clazz);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartObject();
    }

    @Override
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        String string = this.idFromValue(object);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartArray();
    }

    @Override
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        String string = this.idFromValueAndType(object, clazz);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartArray();
    }

    @Override
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        String string = this.idFromValue(object);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        String string = this.idFromValueAndType(object, clazz);
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
        if (!jsonGenerator.canWriteTypeId()) {
            jsonGenerator.writeEndArray();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndArray();
        if (!jsonGenerator.canWriteTypeId()) {
            jsonGenerator.writeEndArray();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        if (!jsonGenerator.canWriteTypeId()) {
            jsonGenerator.writeEndArray();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartObject();
    }

    @Override
    public void writeCustomTypePrefixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeStartArray();
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (jsonGenerator.canWriteTypeId()) {
            if (string != null) {
                jsonGenerator.writeTypeId(string);
            }
        } else {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(string);
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (!jsonGenerator.canWriteTypeId()) {
            this.writeTypeSuffixForObject(object, jsonGenerator);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (!jsonGenerator.canWriteTypeId()) {
            this.writeTypeSuffixForArray(object, jsonGenerator);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        if (!jsonGenerator.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(object, jsonGenerator);
        }
    }
}

