/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.ext.Java7Support;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_SER = new Class[]{JsonSerialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonRawValue.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_DESER = new Class[]{JsonDeserialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Java7Support _java7Helper;
    protected transient LRUMap<Class<?>, Boolean> _annotationsInside = new LRUMap(48, 48);
    protected boolean _cfgConstructorPropertiesImpliesCreator = true;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._annotationsInside == null) {
            this._annotationsInside = new LRUMap(48, 48);
        }
        return this;
    }

    public JacksonAnnotationIntrospector setConstructorPropertiesImpliesCreator(boolean bl) {
        this._cfgConstructorPropertiesImpliesCreator = bl;
        return this;
    }

    @Override
    public boolean isAnnotationBundle(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Boolean bl = this._annotationsInside.get(clazz);
        if (bl == null) {
            bl = clazz.getAnnotation(JacksonAnnotationsInside.class) != null;
            this._annotationsInside.putIfAbsent(clazz, bl);
        }
        return bl;
    }

    @Override
    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        try {
            String string;
            JsonProperty jsonProperty;
            Field field = enum_.getClass().getField(enum_.name());
            if (field != null && (jsonProperty = field.getAnnotation(JsonProperty.class)) != null && (string = jsonProperty.value()) != null && !string.isEmpty()) {
                return string;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return enum_.name();
    }

    @Override
    public String[] findEnumValues(Class<?> clazz, Enum<?>[] enumArray, String[] stringArray) {
        HashMap<String, String> hashMap = null;
        for (Field object : ClassUtil.getDeclaredFields(clazz)) {
            String string;
            JsonProperty jsonProperty;
            if (!object.isEnumConstant() || (jsonProperty = object.getAnnotation(JsonProperty.class)) == null || (string = jsonProperty.value()).isEmpty()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(object.getName(), string);
        }
        if (hashMap != null) {
            int n = enumArray.length;
            for (int i = 0; i < n; ++i) {
                String string = enumArray[i].name();
                String string2 = (String)hashMap.get(string);
                if (string2 == null) continue;
                stringArray[i] = string2;
            }
        }
        return stringArray;
    }

    @Override
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        return ClassUtil.findFirstAnnotatedEnumValue(clazz, JsonEnumDefaultValue.class);
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        JsonRootName jsonRootName = this._findAnnotation(annotatedClass, JsonRootName.class);
        if (jsonRootName == null) {
            return null;
        }
        String string = jsonRootName.namespace();
        if (string != null && string.length() == 0) {
            string = null;
        }
        return PropertyName.construct(jsonRootName.value(), string);
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated annotated) {
        JsonIgnoreProperties jsonIgnoreProperties = this._findAnnotation(annotated, JsonIgnoreProperties.class);
        if (jsonIgnoreProperties == null) {
            return null;
        }
        return JsonIgnoreProperties.Value.from(jsonIgnoreProperties);
    }

    @Override
    @Deprecated
    public String[] findPropertiesToIgnore(Annotated annotated, boolean bl) {
        JsonIgnoreProperties.Value value = this.findPropertyIgnorals(annotated);
        if (value == null) {
            return null;
        }
        if (bl ? value.getAllowGetters() : value.getAllowSetters()) {
            return null;
        }
        Set<String> set = value.getIgnored();
        return set.toArray(new String[set.size()]);
    }

    @Override
    @Deprecated
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        JsonIgnoreProperties.Value value = this.findPropertyIgnorals(annotatedClass);
        return value == null ? null : Boolean.valueOf(value.getIgnoreUnknown());
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        JsonIgnoreType jsonIgnoreType = this._findAnnotation(annotatedClass, JsonIgnoreType.class);
        return jsonIgnoreType == null ? null : Boolean.valueOf(jsonIgnoreType.value());
    }

    @Override
    public Object findFilterId(Annotated annotated) {
        String string;
        JsonFilter jsonFilter = this._findAnnotation(annotated, JsonFilter.class);
        if (jsonFilter != null && (string = jsonFilter.value()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        JsonNaming jsonNaming = this._findAnnotation(annotatedClass, JsonNaming.class);
        return jsonNaming == null ? null : jsonNaming.value();
    }

    @Override
    public String findClassDescription(AnnotatedClass annotatedClass) {
        JsonClassDescription jsonClassDescription = this._findAnnotation(annotatedClass, JsonClassDescription.class);
        return jsonClassDescription == null ? null : jsonClassDescription.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        JsonAutoDetect jsonAutoDetect = this._findAnnotation(annotatedClass, JsonAutoDetect.class);
        return jsonAutoDetect == null ? visibilityChecker : visibilityChecker.with(jsonAutoDetect);
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        PropertyName propertyName = this._findConstructorName(annotatedMember);
        return propertyName == null ? null : propertyName.getSimpleName();
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._isIgnorable(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        JsonProperty jsonProperty = this._findAnnotation(annotatedMember, JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.required();
        }
        return null;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated annotated) {
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.access();
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        JsonPropertyDescription jsonPropertyDescription = this._findAnnotation(annotated, JsonPropertyDescription.class);
        return jsonPropertyDescription == null ? null : jsonPropertyDescription.value();
    }

    @Override
    public Integer findPropertyIndex(Annotated annotated) {
        int n;
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        if (jsonProperty != null && (n = jsonProperty.index()) != -1) {
            return n;
        }
        return null;
    }

    @Override
    public String findPropertyDefaultValue(Annotated annotated) {
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        if (jsonProperty == null) {
            return null;
        }
        String string = jsonProperty.defaultValue();
        return string.isEmpty() ? null : string;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        JsonFormat jsonFormat = this._findAnnotation(annotated, JsonFormat.class);
        return jsonFormat == null ? null : new JsonFormat.Value(jsonFormat);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        JsonManagedReference jsonManagedReference = this._findAnnotation(annotatedMember, JsonManagedReference.class);
        if (jsonManagedReference != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(jsonManagedReference.value());
        }
        JsonBackReference jsonBackReference = this._findAnnotation(annotatedMember, JsonBackReference.class);
        if (jsonBackReference != null) {
            return AnnotationIntrospector.ReferenceProperty.back(jsonBackReference.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        JsonUnwrapped jsonUnwrapped = this._findAnnotation(annotatedMember, JsonUnwrapped.class);
        if (jsonUnwrapped == null || !jsonUnwrapped.enabled()) {
            return null;
        }
        String string = jsonUnwrapped.prefix();
        String string2 = jsonUnwrapped.suffix();
        return NameTransformer.simpleTransformer(string, string2);
    }

    @Override
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        JacksonInject jacksonInject = this._findAnnotation(annotatedMember, JacksonInject.class);
        if (jacksonInject == null) {
            return null;
        }
        String string = jacksonInject.value();
        if (string.length() == 0) {
            if (!(annotatedMember instanceof AnnotatedMethod)) {
                return annotatedMember.getRawType().getName();
            }
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember;
            if (annotatedMethod.getParameterCount() == 0) {
                return annotatedMember.getRawType().getName();
            }
            return annotatedMethod.getRawParameterType(0).getName();
        }
        return string;
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        JsonView jsonView = this._findAnnotation(annotated, JsonView.class);
        return jsonView == null ? null : jsonView.value();
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        Class<?> clazz2 = annotatedMethod2.getRawParameterType(0);
        if (clazz.isPrimitive()) {
            if (!clazz2.isPrimitive()) {
                return annotatedMethod;
            }
        } else if (clazz2.isPrimitive()) {
            return annotatedMethod2;
        }
        if (clazz == String.class) {
            if (clazz2 != String.class) {
                return annotatedMethod;
            }
        } else if (clazz2 == String.class) {
            return annotatedMethod2;
        }
        return null;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return this._findTypeResolver(mapperConfig, annotatedClass, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            return null;
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.getContentType() == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + javaType + ")");
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        JsonSubTypes jsonSubTypes = this._findAnnotation(annotated, JsonSubTypes.class);
        if (jsonSubTypes == null) {
            return null;
        }
        JsonSubTypes.Type[] typeArray = jsonSubTypes.value();
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(typeArray.length);
        for (JsonSubTypes.Type type : typeArray) {
            arrayList.add(new NamedType(type.value(), type.name()));
        }
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        JsonTypeName jsonTypeName = this._findAnnotation(annotatedClass, JsonTypeName.class);
        return jsonTypeName == null ? null : jsonTypeName.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return this._hasAnnotation(annotatedMember, JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        JsonIdentityInfo jsonIdentityInfo = this._findAnnotation(annotated, JsonIdentityInfo.class);
        if (jsonIdentityInfo == null || jsonIdentityInfo.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName propertyName = PropertyName.construct(jsonIdentityInfo.property());
        return new ObjectIdInfo(propertyName, jsonIdentityInfo.scope(), jsonIdentityInfo.generator(), jsonIdentityInfo.resolver());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference jsonIdentityReference = this._findAnnotation(annotated, JsonIdentityReference.class);
        if (jsonIdentityReference != null) {
            objectIdInfo = objectIdInfo.withAlwaysAsId(jsonIdentityReference.alwaysAsId());
        }
        return objectIdInfo;
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object;
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        if (jsonSerialize != null && (object = jsonSerialize.using()) != JsonSerializer.None.class) {
            return object;
        }
        object = this._findAnnotation(annotated, JsonRawValue.class);
        if (object != null && object.value()) {
            Class<?> clazz = annotated.getRawType();
            return new RawSerializer(clazz);
        }
        return null;
    }

    @Override
    public Object findKeySerializer(Annotated annotated) {
        Class<? extends JsonSerializer> clazz;
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        Class<? extends JsonSerializer> clazz;
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated annotated) {
        Class<? extends JsonSerializer> clazz;
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.nullsUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(Annotated annotated, JsonInclude.Include include) {
        Object object;
        JsonInclude jsonInclude = this._findAnnotation(annotated, JsonInclude.class);
        if (jsonInclude != null && (object = jsonInclude.value()) != JsonInclude.Include.USE_DEFAULTS) {
            return object;
        }
        object = this._findAnnotation(annotated, JsonSerialize.class);
        if (object != null) {
            JsonSerialize.Inclusion inclusion = object.include();
            switch (inclusion) {
                case ALWAYS: {
                    return JsonInclude.Include.ALWAYS;
                }
                case NON_NULL: {
                    return JsonInclude.Include.NON_NULL;
                }
                case NON_DEFAULT: {
                    return JsonInclude.Include.NON_DEFAULT;
                }
                case NON_EMPTY: {
                    return JsonInclude.Include.NON_EMPTY;
                }
            }
        }
        return include;
    }

    @Override
    @Deprecated
    public JsonInclude.Include findSerializationInclusionForContent(Annotated annotated, JsonInclude.Include include) {
        JsonInclude.Include include2;
        JsonInclude jsonInclude = this._findAnnotation(annotated, JsonInclude.class);
        if (jsonInclude != null && (include2 = jsonInclude.content()) != JsonInclude.Include.USE_DEFAULTS) {
            return include2;
        }
        return include;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated annotated) {
        Object object;
        JsonInclude.Include include;
        JsonInclude jsonInclude = this._findAnnotation(annotated, JsonInclude.class);
        JsonInclude.Include include2 = include = jsonInclude == null ? JsonInclude.Include.USE_DEFAULTS : jsonInclude.value();
        if (include == JsonInclude.Include.USE_DEFAULTS && (object = this._findAnnotation(annotated, JsonSerialize.class)) != null) {
            JsonSerialize.Inclusion inclusion = object.include();
            switch (inclusion) {
                case ALWAYS: {
                    include = JsonInclude.Include.ALWAYS;
                    break;
                }
                case NON_NULL: {
                    include = JsonInclude.Include.NON_NULL;
                    break;
                }
                case NON_DEFAULT: {
                    include = JsonInclude.Include.NON_DEFAULT;
                    break;
                }
                case NON_EMPTY: {
                    include = JsonInclude.Include.NON_EMPTY;
                    break;
                }
            }
        }
        object = jsonInclude == null ? JsonInclude.Include.USE_DEFAULTS : jsonInclude.content();
        return JsonInclude.Value.construct(include, (JsonInclude.Include)((Object)object));
    }

    @Override
    @Deprecated
    public Class<?> findSerializationType(Annotated annotated) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        return jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.as());
    }

    @Override
    @Deprecated
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        return jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.keyAs());
    }

    @Override
    @Deprecated
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        return jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.contentAs());
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        return jsonSerialize == null ? null : jsonSerialize.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated annotated) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
        return jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        JsonSerialize jsonSerialize = this._findAnnotation(annotatedMember, JsonSerialize.class);
        return jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.contentConverter(), Converter.None.class);
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = this._findAnnotation(annotatedClass, JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : jsonPropertyOrder.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated annotated) {
        return this._findSortAlpha(annotated);
    }

    private final Boolean _findSortAlpha(Annotated annotated) {
        JsonPropertyOrder jsonPropertyOrder = this._findAnnotation(annotated, JsonPropertyOrder.class);
        if (jsonPropertyOrder != null && jsonPropertyOrder.alphabetic()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
        JsonAppend jsonAppend = this._findAnnotation(annotatedClass, JsonAppend.class);
        if (jsonAppend == null) {
            return;
        }
        boolean bl = jsonAppend.prepend();
        JavaType javaType = null;
        JsonAppend.Attr[] attrArray = jsonAppend.attrs();
        int n = attrArray.length;
        for (int i = 0; i < n; ++i) {
            if (javaType == null) {
                javaType = mapperConfig.constructType(Object.class);
            }
            BeanPropertyWriter beanPropertyWriter = this._constructVirtualProperty(attrArray[i], mapperConfig, annotatedClass, javaType);
            if (bl) {
                list.add(i, beanPropertyWriter);
                continue;
            }
            list.add(beanPropertyWriter);
        }
        JsonAppend.Prop[] propArray = jsonAppend.props();
        int n2 = propArray.length;
        for (n = 0; n < n2; ++n) {
            BeanPropertyWriter beanPropertyWriter = this._constructVirtualProperty(propArray[n], mapperConfig, annotatedClass);
            if (bl) {
                list.add(n, beanPropertyWriter);
                continue;
            }
            list.add(beanPropertyWriter);
        }
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Attr attr, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        PropertyMetadata propertyMetadata = attr.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        String string = attr.value();
        PropertyName propertyName = this._propertyName(attr.propName(), attr.propNamespace());
        if (!propertyName.hasSimpleName()) {
            propertyName = PropertyName.construct(string);
        }
        VirtualAnnotatedMember virtualAnnotatedMember = new VirtualAnnotatedMember((TypeResolutionContext)annotatedClass, annotatedClass.getRawType(), string, javaType);
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)virtualAnnotatedMember, propertyName, propertyMetadata, attr.include());
        return AttributePropertyWriter.construct(string, simpleBeanPropertyDefinition, annotatedClass.getAnnotations(), javaType);
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop prop, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        VirtualBeanPropertyWriter virtualBeanPropertyWriter;
        PropertyMetadata propertyMetadata = prop.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        PropertyName propertyName = this._propertyName(prop.name(), prop.namespace());
        JavaType javaType = mapperConfig.constructType(prop.type());
        VirtualAnnotatedMember virtualAnnotatedMember = new VirtualAnnotatedMember((TypeResolutionContext)annotatedClass, annotatedClass.getRawType(), propertyName.getSimpleName(), javaType);
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)virtualAnnotatedMember, propertyName, propertyMetadata, prop.include());
        Class<? extends VirtualBeanPropertyWriter> clazz = prop.value();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        VirtualBeanPropertyWriter virtualBeanPropertyWriter2 = virtualBeanPropertyWriter = handlerInstantiator == null ? null : handlerInstantiator.virtualPropertyWriterInstance(mapperConfig, clazz);
        if (virtualBeanPropertyWriter == null) {
            virtualBeanPropertyWriter = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return virtualBeanPropertyWriter.withConfig(mapperConfig, annotatedClass, simpleBeanPropertyDefinition, javaType);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        JsonGetter jsonGetter = this._findAnnotation(annotated, JsonGetter.class);
        if (jsonGetter != null) {
            return PropertyName.construct(jsonGetter.value());
        }
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        if (jsonProperty != null) {
            return PropertyName.construct(jsonProperty.value());
        }
        if (this._hasOneOf(annotated, ANNOTATIONS_TO_INFER_SER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        JsonValue jsonValue = this._findAnnotation(annotatedMethod, JsonValue.class);
        return jsonValue != null && jsonValue.value();
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer> clazz;
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.using()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        Class<? extends KeyDeserializer> clazz;
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyUsing()) != KeyDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer> clazz;
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentUsing()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(Annotated annotated) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotatedMember, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.contentConverter(), Converter.None.class);
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.contentAs());
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.as());
    }

    @Override
    @Deprecated
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.keyAs());
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        JsonValueInstantiator jsonValueInstantiator = this._findAnnotation(annotatedClass, JsonValueInstantiator.class);
        return jsonValueInstantiator == null ? null : jsonValueInstantiator.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotatedClass, JsonDeserialize.class);
        return jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        JsonPOJOBuilder jsonPOJOBuilder = this._findAnnotation(annotatedClass, JsonPOJOBuilder.class);
        return jsonPOJOBuilder == null ? null : new JsonPOJOBuilder.Value(jsonPOJOBuilder);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        JsonSetter jsonSetter = this._findAnnotation(annotated, JsonSetter.class);
        if (jsonSetter != null) {
            return PropertyName.construct(jsonSetter.value());
        }
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        if (jsonProperty != null) {
            return PropertyName.construct(jsonProperty.value());
        }
        if (this._hasOneOf(annotated, ANNOTATIONS_TO_INFER_DESER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnySetter.class);
    }

    @Override
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnyGetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated annotated) {
        Boolean bl;
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        if (jsonCreator != null) {
            return jsonCreator.mode() != JsonCreator.Mode.DISABLED;
        }
        if (this._cfgConstructorPropertiesImpliesCreator && annotated instanceof AnnotatedConstructor && _java7Helper != null && (bl = _java7Helper.hasCreatorAnnotation(annotated)) != null) {
            return bl;
        }
        return false;
    }

    @Override
    public JsonCreator.Mode findCreatorBinding(Annotated annotated) {
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        return jsonCreator == null ? null : jsonCreator.mode();
    }

    protected boolean _isIgnorable(Annotated annotated) {
        Boolean bl;
        JsonIgnore jsonIgnore = this._findAnnotation(annotated, JsonIgnore.class);
        if (jsonIgnore != null) {
            return jsonIgnore.value();
        }
        if (_java7Helper != null && (bl = _java7Helper.findTransient(annotated)) != null) {
            return bl;
        }
        return false;
    }

    protected Class<?> _classIfExplicit(Class<?> clazz) {
        if (clazz == null || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        return clazz;
    }

    protected Class<?> _classIfExplicit(Class<?> clazz, Class<?> clazz2) {
        return (clazz = this._classIfExplicit(clazz)) == null || clazz == clazz2 ? null : clazz;
    }

    protected PropertyName _propertyName(String string, String string2) {
        if (string.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (string2 == null || string2.isEmpty()) {
            return PropertyName.construct(string);
        }
        return PropertyName.construct(string, string2);
    }

    protected PropertyName _findConstructorName(Annotated annotated) {
        PropertyName propertyName;
        AnnotatedParameter annotatedParameter;
        AnnotatedWithParams annotatedWithParams;
        if (annotated instanceof AnnotatedParameter && (annotatedWithParams = (annotatedParameter = (AnnotatedParameter)annotated).getOwner()) != null && _java7Helper != null && (propertyName = _java7Helper.findConstructorName(annotatedParameter)) != null) {
            return propertyName;
        }
        return null;
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) {
        TypeIdResolver typeIdResolver;
        StdTypeResolverBuilder stdTypeResolverBuilder;
        JsonTypeInfo jsonTypeInfo = this._findAnnotation(annotated, JsonTypeInfo.class);
        JsonTypeResolver jsonTypeResolver = this._findAnnotation(annotated, JsonTypeResolver.class);
        if (jsonTypeResolver != null) {
            if (jsonTypeInfo == null) {
                return null;
            }
            stdTypeResolverBuilder = mapperConfig.typeResolverBuilderInstance(annotated, jsonTypeResolver.value());
        } else {
            if (jsonTypeInfo == null) {
                return null;
            }
            if (jsonTypeInfo.use() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            stdTypeResolverBuilder = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver jsonTypeIdResolver = this._findAnnotation(annotated, JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver2 = typeIdResolver = jsonTypeIdResolver == null ? null : mapperConfig.typeIdResolverInstance(annotated, jsonTypeIdResolver.value());
        if (typeIdResolver != null) {
            typeIdResolver.init(javaType);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.init(jsonTypeInfo.use(), typeIdResolver);
        JsonTypeInfo.As as = jsonTypeInfo.include();
        if (as == JsonTypeInfo.As.EXTERNAL_PROPERTY && annotated instanceof AnnotatedClass) {
            as = JsonTypeInfo.As.PROPERTY;
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.inclusion(as);
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeProperty(jsonTypeInfo.property());
        Class<?> clazz = jsonTypeInfo.defaultImpl();
        if (clazz != JsonTypeInfo.None.class && !clazz.isAnnotation()) {
            stdTypeResolverBuilder = stdTypeResolverBuilder.defaultImpl(clazz);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeIdVisibility(jsonTypeInfo.visible());
        return stdTypeResolverBuilder;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }

    static {
        Java7Support java7Support = null;
        try {
            java7Support = Java7Support.instance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _java7Helper = java7Support;
    }
}

