/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.io.IOException;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _unwrapSingle;

    protected PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
        this._unwrapSingle = null;
    }

    protected PrimitiveArrayDeserializers(PrimitiveArrayDeserializers<?> primitiveArrayDeserializers, Boolean bl) {
        super(primitiveArrayDeserializers._valueClass);
        this._unwrapSingle = bl;
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return IntDeser.instance;
        }
        if (clazz == Long.TYPE) {
            return LongDeser.instance;
        }
        if (clazz == Byte.TYPE) {
            return new ByteDeser();
        }
        if (clazz == Short.TYPE) {
            return new ShortDeser();
        }
        if (clazz == Float.TYPE) {
            return new FloatDeser();
        }
        if (clazz == Double.TYPE) {
            return new DoubleDeser();
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanDeser();
        }
        if (clazz == Character.TYPE) {
            return new CharDeser();
        }
        throw new IllegalStateException();
    }

    protected abstract PrimitiveArrayDeserializers<?> withResolved(Boolean var1);

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl = this.findFormatFeature(deserializationContext, beanProperty, this._valueClass, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl == this._unwrapSingle) {
            return this;
        }
        return this.withResolved(bl);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    protected T handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        if (jsonParser.hasToken(JsonToken.VALUE_STRING) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        boolean bl2 = bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl) {
            return this.handleSingleElementUnwrapped(jsonParser, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected abstract T handleSingleElementUnwrapped(JsonParser var1, DeserializationContext var2) throws IOException;

    @JacksonStdImpl
    static final class DoubleDeser
    extends PrimitiveArrayDeserializers<double[]> {
        private static final long serialVersionUID = 1L;

        public DoubleDeser() {
            super(double[].class);
        }

        protected DoubleDeser(DoubleDeser doubleDeser, Boolean bl) {
            super(doubleDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new DoubleDeser(this, bl);
        }

        @Override
        public double[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (double[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.DoubleBuilder doubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
            double[] dArray = (double[])doubleBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    double d = this._parseDoublePrimitive(jsonParser, deserializationContext);
                    if (n >= dArray.length) {
                        dArray = doubleBuilder.appendCompletedChunk(dArray, n);
                        n = 0;
                    }
                    dArray[n++] = d;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)dArray, doubleBuilder.bufferedSize() + n);
            }
            return doubleBuilder.completeAndClearBuffer(dArray, n);
        }

        @Override
        protected double[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new double[]{this._parseDoublePrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class FloatDeser
    extends PrimitiveArrayDeserializers<float[]> {
        private static final long serialVersionUID = 1L;

        public FloatDeser() {
            super(float[].class);
        }

        protected FloatDeser(FloatDeser floatDeser, Boolean bl) {
            super(floatDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new FloatDeser(this, bl);
        }

        @Override
        public float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (float[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.FloatBuilder floatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
            float[] fArray = (float[])floatBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    float f = this._parseFloatPrimitive(jsonParser, deserializationContext);
                    if (n >= fArray.length) {
                        fArray = floatBuilder.appendCompletedChunk(fArray, n);
                        n = 0;
                    }
                    fArray[n++] = f;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)fArray, floatBuilder.bufferedSize() + n);
            }
            return floatBuilder.completeAndClearBuffer(fArray, n);
        }

        @Override
        protected float[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new float[]{this._parseFloatPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class LongDeser
    extends PrimitiveArrayDeserializers<long[]> {
        private static final long serialVersionUID = 1L;
        public static final LongDeser instance = new LongDeser();

        public LongDeser() {
            super(long[].class);
        }

        protected LongDeser(LongDeser longDeser, Boolean bl) {
            super(longDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new LongDeser(this, bl);
        }

        @Override
        public long[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (long[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.LongBuilder longBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
            long[] lArray = (long[])longBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    long l = this._parseLongPrimitive(jsonParser, deserializationContext);
                    if (n >= lArray.length) {
                        lArray = longBuilder.appendCompletedChunk(lArray, n);
                        n = 0;
                    }
                    lArray[n++] = l;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)lArray, longBuilder.bufferedSize() + n);
            }
            return longBuilder.completeAndClearBuffer(lArray, n);
        }

        @Override
        protected long[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new long[]{this._parseLongPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class IntDeser
    extends PrimitiveArrayDeserializers<int[]> {
        private static final long serialVersionUID = 1L;
        public static final IntDeser instance = new IntDeser();

        public IntDeser() {
            super(int[].class);
        }

        protected IntDeser(IntDeser intDeser, Boolean bl) {
            super(intDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new IntDeser(this, bl);
        }

        @Override
        public int[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (int[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.IntBuilder intBuilder = deserializationContext.getArrayBuilders().getIntBuilder();
            int[] nArray = (int[])intBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
                    if (n >= nArray.length) {
                        nArray = intBuilder.appendCompletedChunk(nArray, n);
                        n = 0;
                    }
                    nArray[n++] = n2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)nArray, intBuilder.bufferedSize() + n);
            }
            return intBuilder.completeAndClearBuffer(nArray, n);
        }

        @Override
        protected int[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new int[]{this._parseIntPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class ShortDeser
    extends PrimitiveArrayDeserializers<short[]> {
        private static final long serialVersionUID = 1L;

        public ShortDeser() {
            super(short[].class);
        }

        protected ShortDeser(ShortDeser shortDeser, Boolean bl) {
            super(shortDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new ShortDeser(this, bl);
        }

        @Override
        public short[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (short[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.ShortBuilder shortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
            short[] sArray = (short[])shortBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    short s = this._parseShortPrimitive(jsonParser, deserializationContext);
                    if (n >= sArray.length) {
                        sArray = shortBuilder.appendCompletedChunk(sArray, n);
                        n = 0;
                    }
                    sArray[n++] = s;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)sArray, shortBuilder.bufferedSize() + n);
            }
            return shortBuilder.completeAndClearBuffer(sArray, n);
        }

        @Override
        protected short[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new short[]{this._parseShortPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class ByteDeser
    extends PrimitiveArrayDeserializers<byte[]> {
        private static final long serialVersionUID = 1L;

        public ByteDeser() {
            super(byte[].class);
        }

        protected ByteDeser(ByteDeser byteDeser, Boolean bl) {
            super(byteDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new ByteDeser(this, bl);
        }

        @Override
        public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Object object;
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof byte[]) {
                    return (byte[])object;
                }
            }
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (byte[])this.handleNonArray(jsonParser, deserializationContext);
            }
            object = deserializationContext.getArrayBuilders().getByteBuilder();
            byte[] byArray = (byte[])((PrimitiveArrayBuilder)object).resetAndStart();
            int n = 0;
            try {
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    byte by;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                        by = jsonParser.getByteValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        by = 0;
                    } else {
                        Number number = (Number)deserializationContext.handleUnexpectedToken(this._valueClass.getComponentType(), jsonParser);
                        by = number.byteValue();
                    }
                    if (n >= byArray.length) {
                        byArray = ((PrimitiveArrayBuilder)object).appendCompletedChunk(byArray, n);
                        n = 0;
                    }
                    byArray[n++] = by;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)byArray, ((PrimitiveArrayBuilder)object).bufferedSize() + n);
            }
            return ((PrimitiveArrayBuilder)object).completeAndClearBuffer(byArray, n);
        }

        @Override
        protected byte[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte by;
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                by = jsonParser.getByteValue();
            } else {
                if (jsonToken == JsonToken.VALUE_NULL) {
                    return null;
                }
                Number number = (Number)deserializationContext.handleUnexpectedToken(this._valueClass.getComponentType(), jsonParser);
                by = number.byteValue();
            }
            return new byte[]{by};
        }
    }

    @JacksonStdImpl
    static final class BooleanDeser
    extends PrimitiveArrayDeserializers<boolean[]> {
        private static final long serialVersionUID = 1L;

        public BooleanDeser() {
            super(boolean[].class);
        }

        protected BooleanDeser(BooleanDeser booleanDeser, Boolean bl) {
            super(booleanDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return new BooleanDeser(this, bl);
        }

        @Override
        public boolean[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (boolean[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.BooleanBuilder booleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
            boolean[] blArray = (boolean[])booleanBuilder.resetAndStart();
            int n = 0;
            try {
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    boolean bl = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                    if (n >= blArray.length) {
                        blArray = booleanBuilder.appendCompletedChunk(blArray, n);
                        n = 0;
                    }
                    blArray[n++] = bl;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)blArray, booleanBuilder.bufferedSize() + n);
            }
            return booleanBuilder.completeAndClearBuffer(blArray, n);
        }

        @Override
        protected boolean[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new boolean[]{this._parseBooleanPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class CharDeser
    extends PrimitiveArrayDeserializers<char[]> {
        private static final long serialVersionUID = 1L;

        public CharDeser() {
            super(char[].class);
        }

        protected CharDeser(CharDeser charDeser, Boolean bl) {
            super(charDeser, bl);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(Boolean bl) {
            return this;
        }

        @Override
        public char[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                char[] cArray = jsonParser.getTextCharacters();
                int n = jsonParser.getTextOffset();
                int n2 = jsonParser.getTextLength();
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                return cArray2;
            }
            if (jsonParser.isExpectedStartArrayToken()) {
                StringBuilder stringBuilder = new StringBuilder(64);
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    String string;
                    if (jsonToken == JsonToken.VALUE_STRING) {
                        string = jsonParser.getText();
                    } else {
                        CharSequence charSequence = (CharSequence)deserializationContext.handleUnexpectedToken(Character.TYPE, jsonParser);
                        string = charSequence.toString();
                    }
                    if (string.length() != 1) {
                        deserializationContext.reportMappingException("Can not convert a JSON String of length %d into a char element of char array", string.length());
                    }
                    stringBuilder.append(string.charAt(0));
                }
                return stringBuilder.toString().toCharArray();
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                Object object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof char[]) {
                    return (char[])object;
                }
                if (object instanceof String) {
                    return ((String)object).toCharArray();
                }
                if (object instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])object, false).toCharArray();
                }
            }
            return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }

        @Override
        protected char[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }
}

