/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_classNames.contains(string)) {
            FromStringDeserializer.Std std = FromStringDeserializer.findDeserializer(clazz);
            if (std != null) {
                return std;
            }
            if (clazz == UUID.class) {
                return new UUIDDeserializer();
            }
            if (clazz == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (clazz == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (clazz == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
        }
        return null;
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, AtomicBoolean.class, StackTraceElement.class, ByteBuffer.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

