/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class FactoryBasedEnumDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _inputType;
    protected final boolean _hasArgs;
    protected final AnnotatedMethod _factory;
    protected final JsonDeserializer<?> _deser;
    protected final ValueInstantiator _valueInstantiator;
    protected final SettableBeanProperty[] _creatorProps;
    private transient PropertyBasedCreator _propCreator;

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, JavaType javaType, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = true;
        this._inputType = javaType.hasRawClass(String.class) ? null : javaType;
        this._deser = null;
        this._valueInstantiator = valueInstantiator;
        this._creatorProps = settableBeanPropertyArray;
    }

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = false;
        this._inputType = null;
        this._deser = null;
        this._valueInstantiator = null;
        this._creatorProps = null;
    }

    protected FactoryBasedEnumDeserializer(FactoryBasedEnumDeserializer factoryBasedEnumDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(factoryBasedEnumDeserializer._valueClass);
        this._inputType = factoryBasedEnumDeserializer._inputType;
        this._factory = factoryBasedEnumDeserializer._factory;
        this._hasArgs = factoryBasedEnumDeserializer._hasArgs;
        this._valueInstantiator = factoryBasedEnumDeserializer._valueInstantiator;
        this._creatorProps = factoryBasedEnumDeserializer._creatorProps;
        this._deser = jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._deser == null && this._inputType != null) {
            return new FactoryBasedEnumDeserializer(this, deserializationContext.findContextualValueDeserializer(this._inputType, beanProperty));
        }
        return this;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = null;
        if (this._deser != null) {
            string = (String)this._deser.deserialize(jsonParser, deserializationContext);
        } else if (this._hasArgs) {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.FIELD_NAME) {
                string = jsonParser.getText();
            } else {
                if (this._creatorProps != null && jsonParser.isExpectedStartObjectToken()) {
                    if (this._propCreator == null) {
                        this._propCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, this._creatorProps);
                    }
                    jsonParser.nextToken();
                    return this.deserializeEnumUsingPropertyBased(jsonParser, deserializationContext, this._propCreator);
                }
                string = jsonParser.getValueAsString();
            }
        } else {
            jsonParser.skipChildren();
            try {
                return this._factory.call();
            }
            catch (Exception exception) {
                Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
                return deserializationContext.handleInstantiationProblem(this._valueClass, null, throwable);
            }
        }
        try {
            return this._factory.callOnWith(this._valueClass, string);
        }
        catch (Exception exception) {
            Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
            return deserializationContext.handleInstantiationProblem(this._valueClass, string, throwable);
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        if (this._deser == null) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected Object deserializeEnumUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyBasedCreator propertyBasedCreator) throws IOException {
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
            if (settableBeanProperty != null) {
                if (propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty))) {
                    jsonParser.nextToken();
                }
            } else if (propertyValueBuffer.readIdProperty(string)) {
                // empty if block
            }
            jsonToken = jsonParser.nextToken();
        }
        return propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser jsonParser, DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws IOException {
        try {
            return settableBeanProperty.deserialize(jsonParser, deserializationContext);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, this._valueClass.getClass(), settableBeanProperty.getName(), deserializationContext);
            return null;
        }
    }

    public void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonProcessingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }
}

