/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    protected DefaultDeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        super(deserializerFactory, deserializerCache);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        super(defaultDeserializationContext, deserializationConfig, jsonParser, injectableValues);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializerFactory deserializerFactory) {
        super(defaultDeserializationContext, deserializerFactory);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext) {
        super(defaultDeserializationContext);
    }

    public DefaultDeserializationContext copy() {
        throw new IllegalStateException("DefaultDeserializationContext sub-class not overriding copy()");
    }

    @Override
    public ReadableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator, ObjectIdResolver objectIdResolver) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectIdGenerator.IdKey idKey = objectIdGenerator.key(object);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            object2 = this._objectIds.get(idKey);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver objectIdResolver2 : this._objectIdResolvers) {
                if (!objectIdResolver2.canUseFor(objectIdResolver)) continue;
                object2 = objectIdResolver2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdResolver.newForDeserialization(this);
            this._objectIdResolvers.add((ObjectIdResolver)object2);
        }
        ReadableObjectId readableObjectId = this.createReadableObjectId(idKey);
        readableObjectId.setResolver((ObjectIdResolver)object2);
        this._objectIds.put(idKey, readableObjectId);
        return readableObjectId;
    }

    protected ReadableObjectId createReadableObjectId(ObjectIdGenerator.IdKey idKey) {
        return new ReadableObjectId(idKey);
    }

    @Override
    public void checkUnresolvedObjectId() throws UnresolvedForwardReference {
        if (this._objectIds == null) {
            return;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            return;
        }
        UnresolvedForwardReference unresolvedForwardReference = null;
        for (Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId> entry : this._objectIds.entrySet()) {
            ReadableObjectId readableObjectId = entry.getValue();
            if (!readableObjectId.hasReferringProperties() || this.tryToResolveUnresolvedObjectId(readableObjectId)) continue;
            if (unresolvedForwardReference == null) {
                unresolvedForwardReference = new UnresolvedForwardReference(this.getParser(), "Unresolved forward references for: ");
            }
            Object object = readableObjectId.getKey().key;
            Iterator<ReadableObjectId.Referring> iterator = readableObjectId.referringProperties();
            while (iterator.hasNext()) {
                ReadableObjectId.Referring referring = iterator.next();
                unresolvedForwardReference.addUnresolvedId(object, referring.getBeanType(), referring.getLocation());
            }
        }
        if (unresolvedForwardReference != null) {
            throw unresolvedForwardReference;
        }
    }

    protected boolean tryToResolveUnresolvedObjectId(ReadableObjectId readableObjectId) {
        return readableObjectId.tryToResolveUnresolved(this);
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonDeserializer) {
            jsonDeserializer = (JsonDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + object.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonDeserializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer2 = jsonDeserializer = handlerInstantiator == null ? null : handlerInstantiator.deserializerInstance(this._config, annotated, clazz);
            if (jsonDeserializer == null) {
                jsonDeserializer = (JsonDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        if (jsonDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(this);
        }
        return jsonDeserializer;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        KeyDeserializer keyDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof KeyDeserializer) {
            keyDeserializer = (KeyDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == KeyDeserializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer2 = keyDeserializer = handlerInstantiator == null ? null : handlerInstantiator.keyDeserializerInstance(this._config, annotated, clazz);
            if (keyDeserializer == null) {
                keyDeserializer = (KeyDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(this);
        }
        return keyDeserializer;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory deserializerFactory) {
            super(deserializerFactory, null);
        }

        protected Impl(Impl impl, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            super(impl, deserializationConfig, jsonParser, injectableValues);
        }

        protected Impl(Impl impl) {
            super(impl);
        }

        protected Impl(Impl impl, DeserializerFactory deserializerFactory) {
            super(impl, deserializerFactory);
        }

        @Override
        public DefaultDeserializationContext copy() {
            if (this.getClass() != Impl.class) {
                return super.copy();
            }
            return new Impl(this);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            return new Impl(this, deserializationConfig, jsonParser, injectableValues);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory deserializerFactory) {
            return new Impl(this, deserializerFactory);
        }
    }
}

