/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;

public class VersionUtil {
    private static final Pattern V_SEP = Pattern.compile("[-_./;:]");
    private final Version _v;

    protected VersionUtil() {
        Version version = null;
        try {
            version = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information from " + this.getClass());
        }
        if (version == null) {
            version = Version.unknownVersion();
        }
        this._v = version;
    }

    public Version version() {
        return this._v;
    }

    public static Version versionFor(Class<?> clazz) {
        Version version = VersionUtil.packageVersionFor(clazz);
        return version == null ? Version.unknownVersion() : version;
    }

    public static Version packageVersionFor(Class<?> clazz) {
        Version version = null;
        try {
            String string = clazz.getPackage().getName() + ".PackageVersion";
            Class<?> clazz2 = Class.forName(string, true, clazz.getClassLoader());
            try {
                version = ((Versioned)clazz2.newInstance()).version();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to get Versioned out of " + clazz2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version == null ? Version.unknownVersion() : version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Version mavenVersionFor(ClassLoader classLoader, String string, String string2) {
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string.replaceAll("\\.", "/") + "/" + string2 + "/pom.properties");
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string3 = properties.getProperty("version");
                String string4 = properties.getProperty("artifactId");
                String string5 = properties.getProperty("groupId");
                Version version = VersionUtil.parseVersion(string3, string5, string4);
                return version;
            }
            catch (IOException iOException) {
            }
            finally {
                VersionUtil._close(inputStream);
            }
        }
        return Version.unknownVersion();
    }

    public static Version parseVersion(String string, String string2, String string3) {
        if (string != null && (string = string.trim()).length() > 0) {
            String[] stringArray = V_SEP.split(string);
            return new Version(VersionUtil.parseVersionPart(stringArray[0]), stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0, stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0, stringArray.length > 3 ? stringArray[3] : null, string2, string3);
        }
        return Version.unknownVersion();
    }

    protected static int parseVersionPart(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2 && (c = string.charAt(i)) <= '9' && c >= '0'; ++i) {
            n = n * 10 + (c - 48);
        }
        return n;
    }

    private static final void _close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

