/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.ASCIIPropertyListWriter;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListConverter;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import com.dd.plist.XMLPropertyListWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PropertyListParser {
    private static final int TYPE_XML = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_ERROR_BLANK = 10;
    private static final int TYPE_ERROR_UNKNOWN = 11;
    private static final int READ_BUFFER_LENGTH = 4096;

    protected PropertyListParser() {
    }

    private static int determineType(String string) {
        if ((string = string.trim()).length() == 0) {
            return 10;
        }
        if (string.startsWith("bplist")) {
            return 1;
        }
        if (string.startsWith("(") || string.startsWith("{") || string.startsWith("/")) {
            return 2;
        }
        if (string.startsWith("<")) {
            return 0;
        }
        return 11;
    }

    private static int determineType(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = n;
        int n4 = n3 + 1024;
        if (inputStream.markSupported()) {
            inputStream.mark(n4);
        }
        inputStream.skip(n);
        ByteOrderMarkReader byteOrderMarkReader = new ByteOrderMarkReader();
        boolean bl = true;
        do {
            if (++n3 <= n4) continue;
            inputStream.reset();
            return PropertyListParser.determineType(inputStream, n4);
        } while ((n2 = inputStream.read()) != -1 && (n2 == 32 || n2 == 9 || n2 == 13 || n2 == 10 || n2 == 12 || (bl &= byteOrderMarkReader.readByte(n2))));
        if (n2 == -1) {
            return 10;
        }
        String string = byteOrderMarkReader.getDetectedCharset();
        if (string == null) {
            string = "UTF-8";
        }
        byte[] byArray = new byte[8];
        byArray[0] = (byte)n2;
        int n5 = inputStream.read(byArray, 1, 7);
        if (n5 == -1) {
            return 11;
        }
        int n6 = PropertyListParser.determineType(new String(byArray, 0, n5, Charset.forName(string)));
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        return n6;
    }

    protected static byte[] readAll(InputStream inputStream) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "The specified input stream is null");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static NSObject parse(String string) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return PropertyListParser.parse(FileSystems.getDefault().getPath(string, new String[0]));
    }

    public static NSObject parse(File file) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(file.toPath());
    }

    public static NSObject parse(Path path) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = PropertyListParser.parse(inputStream);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] byArray) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(new ByteArrayInputStream(byArray));
    }

    public static NSObject parse(InputStream inputStream) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        switch (PropertyListParser.determineType(inputStream, 0)) {
            case 1: {
                return BinaryPropertyListParser.parse(inputStream);
            }
            case 0: {
                return XMLPropertyListParser.parse(inputStream);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(inputStream);
            }
            case 10: {
                return null;
            }
        }
        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
    }

    @Deprecated
    public static void saveAsXML(NSObject nSObject, File file) throws IOException {
        XMLPropertyListWriter.write(nSObject, file);
    }

    @Deprecated
    public static void saveAsXML(NSObject nSObject, OutputStream outputStream) throws IOException {
        XMLPropertyListWriter.write(nSObject, outputStream);
    }

    @Deprecated
    public static void convertToXml(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToXml(file, file2);
    }

    public static void saveAsBinary(NSObject nSObject, File file) throws IOException {
        BinaryPropertyListWriter.write(nSObject, file, true);
    }

    @Deprecated
    public static void saveAsBinary(NSObject nSObject, OutputStream outputStream) throws IOException {
        BinaryPropertyListWriter.write(nSObject, outputStream);
    }

    @Deprecated
    public static void convertToBinary(File file, File file2) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        PropertyListConverter.convertToBinary(file, file2);
    }

    @Deprecated
    public static void saveAsASCII(NSDictionary nSDictionary, File file) throws IOException {
        ASCIIPropertyListWriter.write(nSDictionary, file);
    }

    @Deprecated
    public static void saveAsASCII(NSArray nSArray, File file) throws IOException {
        ASCIIPropertyListWriter.write(nSArray, file);
    }

    @Deprecated
    public static void convertToASCII(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToASCII(file, file2);
    }

    @Deprecated
    public static void saveAsGnuStepASCII(NSDictionary nSDictionary, File file) throws IOException {
        ASCIIPropertyListWriter.writeGnuStep(nSDictionary, file);
    }

    @Deprecated
    public static void saveAsGnuStepASCII(NSArray nSArray, File file) throws IOException {
        ASCIIPropertyListWriter.writeGnuStep(nSArray, file);
    }

    @Deprecated
    public static void convertToGnuStepASCII(File file, File file2) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToGnuStepASCII(file, file2);
    }
}

