/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.impl.FSM;

class TransitionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MutableTransition<T, S, E, C> {
    private ImmutableState<T, S, E, C> sourceState;
    private ImmutableState<T, S, E, C> targetState;
    private E event;
    private final Actions<T, S, E, C> actions = FSM.newActions();
    private Condition<C> condition = Conditions.always();
    private TransitionType type = TransitionType.EXTERNAL;
    private int priority;

    TransitionImpl() {
    }

    @Override
    public ImmutableState<T, S, E, C> getSourceState() {
        return this.sourceState;
    }

    @Override
    public ImmutableState<T, S, E, C> getTargetState() {
        return this.targetState;
    }

    @Override
    public List<Action<T, S, E, C>> getActions() {
        return this.actions.getAll();
    }

    @Override
    public ImmutableState<T, S, E, C> transit(StateContext<T, S, E, C> stateContext) {
        stateContext.getExecutor().begin("TRANSITION__" + this.toString());
        for (Action<T, S, E, C> action : this.getActions()) {
            stateContext.getExecutor().defer(action, this.sourceState.getStateId(), this.targetState.getStateId(), stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        return this.targetState;
    }

    @Override
    public void setSourceState(ImmutableState<T, S, E, C> immutableState) {
        this.sourceState = immutableState;
    }

    @Override
    public void setTargetState(ImmutableState<T, S, E, C> immutableState) {
        this.targetState = immutableState;
    }

    @Override
    public void addAction(Action<T, S, E, C> action) {
        this.actions.add(action);
    }

    @Override
    public void addActions(List<? extends Action<T, S, E, C>> list) {
        this.actions.addAll(list);
    }

    @Override
    public Condition<C> getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Condition<C> condition) {
        this.condition = condition;
    }

    @Override
    public E getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(E e) {
        this.event = e;
    }

    @Override
    public TransitionType getType() {
        return this.type;
    }

    @Override
    public void setType(TransitionType transitionType) {
        this.type = transitionType;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    private void doTransit(ImmutableState<T, S, E, C> immutableState, ImmutableState<T, S, E, C> immutableState2, StateContext<T, S, E, C> stateContext) {
        if (immutableState2.isChildStateOf(immutableState) && this.type == TransitionType.EXTERNAL) {
            immutableState.exit(stateContext);
            immutableState.entry(stateContext);
        }
        this.doTransitInternal(immutableState, immutableState2, stateContext);
    }

    private void doTransitInternal(ImmutableState<T, S, E, C> immutableState, ImmutableState<T, S, E, C> immutableState2, StateContext<T, S, E, C> stateContext) {
        if (immutableState == this.getTargetState()) {
            if (this.type == TransitionType.LOCAL) {
                this.transit(stateContext);
            } else {
                immutableState.exit(stateContext);
                this.transit(stateContext);
                this.getTargetState().entry(stateContext);
            }
        } else if (immutableState == immutableState2) {
            this.transit(stateContext);
        } else if (immutableState.getParentState() == immutableState2.getParentState()) {
            immutableState.exit(stateContext);
            this.transit(stateContext);
            immutableState2.entry(stateContext);
        } else if (immutableState.getLevel() > immutableState2.getLevel()) {
            immutableState.exit(stateContext);
            this.doTransitInternal(immutableState.getParentState(), immutableState2, stateContext);
        } else if (immutableState.getLevel() < immutableState2.getLevel()) {
            this.doTransitInternal(immutableState, immutableState2.getParentState(), stateContext);
            immutableState2.entry(stateContext);
        } else {
            immutableState.exit(stateContext);
            this.doTransitInternal(immutableState.getParentState(), immutableState2.getParentState(), stateContext);
            immutableState2.entry(stateContext);
        }
    }

    @Override
    public void internalFire(StateContext<T, S, E, C> stateContext) {
        if (this.type == TransitionType.INTERNAL && stateContext.getSourceState().getStateId() != this.targetState.getStateId()) {
            return;
        }
        if (this.condition.isSatisfied(stateContext.getContext())) {
            ImmutableState<T, S, E, C> immutableState = stateContext.getSourceState();
            if (this.type == TransitionType.INTERNAL) {
                immutableState = this.transit(stateContext);
            } else {
                this.unwindSubStates(stateContext.getSourceState(), stateContext);
                this.doTransit(this.getSourceState(), this.getTargetState(), stateContext);
                immutableState = this.getTargetState().enterByHistory(stateContext);
            }
            stateContext.getResult().setAccepted(true).setTargetState(immutableState);
        }
    }

    private void unwindSubStates(ImmutableState<T, S, E, C> immutableState, StateContext<T, S, E, C> stateContext) {
        for (ImmutableState<T, S, E, C> immutableState2 = immutableState; immutableState2 != this.getSourceState(); immutableState2 = immutableState2.getParentState()) {
            if (immutableState2 == null) continue;
            immutableState2.exit(stateContext);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        visitor.visitOnExit(this);
    }

    @Override
    public boolean isMatch(S s, S s2, E e, int n) {
        if (s2 == null && !this.getTargetState().isFinalState()) {
            return false;
        }
        if (s2 != null && !this.getTargetState().isFinalState() && !this.getTargetState().getStateId().equals(s2)) {
            return false;
        }
        if (!this.getEvent().equals(e)) {
            return false;
        }
        return this.getPriority() == n;
    }

    @Override
    public boolean isMatch(S s, S s2, E e, int n, Class<?> clazz, TransitionType transitionType) {
        if (!this.isMatch(s, s2, e, n)) {
            return false;
        }
        if (this.getCondition().getClass() != clazz) {
            return false;
        }
        return this.getType().equals((Object)transitionType);
    }

    public final String toString() {
        return this.sourceState + "-[" + this.event.toString() + ", " + this.condition.name() + ", " + this.priority + ", " + (Object)((Object)this.type) + "]->" + this.targetState;
    }

    @Override
    public void verify() {
        if (this.type == TransitionType.INTERNAL && this.sourceState != this.targetState) {
            throw new RuntimeException(String.format("Internal transition source state '%s' and target state '%s' must be same.", this.sourceState, this.targetState));
        }
    }
}

