/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.AnonymousAction;
import org.squirrelframework.foundation.fsm.ImmutableTimedState;
import org.squirrelframework.foundation.fsm.MutableTimedState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.StateImpl;

public class TimedStateImpl<T extends StateMachine<T, S, E, C>, S, E, C>
extends StateImpl<T, S, E, C>
implements ImmutableTimedState<T, S, E, C>,
MutableTimedState<T, S, E, C> {
    private long timeInterval;
    private long initialDelay;
    private E autoFireEvent;
    private C autoFireContext;
    private final ScheduledExecutorService scheduler = SquirrelConfiguration.getScheduler();
    private final transient Map<String, Future<?>> futures = Maps.newConcurrentMap();
    private Action<T, S, E, C> lastEntryAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S s, S s2, E e, C c, T t) {
            Runnable runnable = new Runnable((StateMachine)t){
                final /* synthetic */ StateMachine val$stateMachine;
                {
                    this.val$stateMachine = stateMachine;
                }

                @Override
                public void run() {
                    this.val$stateMachine.fire(TimedStateImpl.this.autoFireEvent, TimedStateImpl.this.autoFireContext);
                }
            };
            ScheduledFuture<?> scheduledFuture = TimedStateImpl.this.timeInterval <= 0L ? TimedStateImpl.this.scheduler.schedule(runnable, TimedStateImpl.this.initialDelay, TimeUnit.MILLISECONDS) : TimedStateImpl.this.scheduler.scheduleAtFixedRate(runnable, TimedStateImpl.this.initialDelay, TimedStateImpl.this.timeInterval, TimeUnit.MILLISECONDS);
            TimedStateImpl.this.futures.put(TimedStateImpl.this.getKey(t), scheduledFuture);
        }

        @Override
        public int weight() {
            return -2147483647;
        }

        @Override
        public String name() {
            return "__TIMED_STATE_ENTRY_ACTION";
        }
    };
    private Action<T, S, E, C> firstExitAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S s, S s2, E e, C c, T t) {
            Future future = (Future)TimedStateImpl.this.futures.remove(TimedStateImpl.this.getKey(t));
            if (future != null) {
                future.cancel(false);
            }
        }

        @Override
        public int weight() {
            return 0x7FFFFFFE;
        }

        @Override
        public String name() {
            return "__TIMED_STATE_EXIT_ACTION";
        }
    };

    TimedStateImpl(S s) {
        super(s);
        this.entryActions.add(this.lastEntryAction);
        this.exitActions.add(this.firstExitAction);
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public E getAutoFireEvent() {
        return this.autoFireEvent;
    }

    @Override
    public void setTimeInterval(long l) {
        this.timeInterval = l;
    }

    @Override
    public void setAutoFireEvent(E e) {
        this.autoFireEvent = e;
    }

    @Override
    public void setInitialDelay(long l) {
        this.initialDelay = l;
    }

    @Override
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    public void setAutoFireContext(C c) {
        this.autoFireContext = c;
    }

    @Override
    public C getAutoFireContext() {
        return this.autoFireContext;
    }
}

