/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.builder.And;
import org.squirrelframework.foundation.fsm.builder.Between;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.MultiFrom;
import org.squirrelframework.foundation.fsm.builder.MultiTo;
import org.squirrelframework.foundation.fsm.builder.MultiTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

class MultiTransitionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MultiTransitionBuilder<T, S, E, C>,
MultiFrom<T, S, E, C>,
From<T, S, E, C>,
MultiTo<T, S, E, C>,
To<T, S, E, C>,
On<T, S, E, C>,
Between<T, S, E, C>,
And<T, S, E, C>,
SquirrelComponent {
    private final List<MutableTransition<T, S, E, C>> transitions = Lists.newArrayList();
    private final List<MutableState<T, S, E, C>> sourceStates = Lists.newArrayList();
    private final List<MutableState<T, S, E, C>> targetStates = Lists.newArrayList();
    private final Map<S, MutableState<T, S, E, C>> states;
    private final int priority;
    private final ExecutionContext executionContext;
    private final TransitionType transitionType;

    MultiTransitionBuilderImpl(Map<S, MutableState<T, S, E, C>> map, TransitionType transitionType, int n, ExecutionContext executionContext) {
        this.states = map;
        this.transitionType = transitionType;
        this.priority = n;
        this.executionContext = executionContext;
    }

    @Override
    public MultiTo<T, S, E, C> toAmong(S ... SArray) {
        for (S s : SArray) {
            this.targetStates.add(FSM.getState(this.states, s));
        }
        return this;
    }

    @Override
    public To<T, S, E, C> to(S s) {
        this.targetStates.add(FSM.getState(this.states, s));
        return this;
    }

    @Override
    public To<T, S, E, C> toFinal(S s) {
        MutableState<T, S, E, C> mutableState = FSM.getState(this.states, s);
        if (!mutableState.isFinalState()) {
            mutableState.setFinal(true);
        }
        this.targetStates.add(mutableState);
        return this;
    }

    @Override
    public MultiFrom<T, S, E, C> from(S s) {
        this.sourceStates.add(FSM.getState(this.states, s));
        return this;
    }

    @Override
    public From<T, S, E, C> fromAmong(S ... SArray) {
        for (S s : SArray) {
            this.sourceStates.add(FSM.getState(this.states, s));
        }
        return this;
    }

    @Override
    public Between<T, S, E, C> between(S s) {
        this.sourceStates.add(FSM.getState(this.states, s));
        return this;
    }

    @Override
    public And<T, S, E, C> and(S s) {
        this.targetStates.add(FSM.getState(this.states, s));
        return this;
    }

    @Override
    public On<T, S, E, C> onMutual(E e, E e2) {
        MutableTransition<T, S, E, C> mutableTransition = this.sourceStates.get(0).addTransitionOn(e);
        mutableTransition.setTargetState(this.targetStates.get(0));
        mutableTransition.setType(this.transitionType);
        mutableTransition.setPriority(this.priority);
        this.transitions.add(mutableTransition);
        MutableTransition<T, S, E, C> mutableTransition2 = this.targetStates.get(0).addTransitionOn(e2);
        mutableTransition2.setTargetState(this.sourceStates.get(0));
        mutableTransition2.setType(this.transitionType);
        mutableTransition2.setPriority(this.priority);
        this.transitions.add(mutableTransition2);
        return this;
    }

    @Override
    public On<T, S, E, C> on(E e) {
        for (MutableState<T, S, E, C> mutableState : this.sourceStates) {
            for (MutableState<T, S, E, C> mutableState2 : this.targetStates) {
                MutableTransition<T, S, E, C> mutableTransition = mutableState.addTransitionOn(e);
                mutableTransition.setTargetState(mutableState2);
                mutableTransition.setType(this.transitionType);
                mutableTransition.setPriority(this.priority);
                this.transitions.add(mutableTransition);
            }
        }
        return this;
    }

    @Override
    public On<T, S, E, C> onEach(E ... EArray) {
        Preconditions.checkNotNull(EArray);
        int n = EArray.length;
        int n2 = this.sourceStates.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.targetStates.size();
            for (int j = 0; j < n3; ++j) {
                int n4 = j < i ? i : j;
                int n5 = n4 < n ? n4 : n - 1;
                MutableTransition<T, S, E, C> mutableTransition = this.sourceStates.get(i).addTransitionOn(EArray[n5]);
                mutableTransition.setTargetState(this.targetStates.get(j));
                mutableTransition.setType(this.transitionType);
                mutableTransition.setPriority(this.priority);
                this.transitions.add(mutableTransition);
            }
        }
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        for (MutableTransition<T, S, E, C> mutableTransition : this.transitions) {
            mutableTransition.setCondition(condition);
        }
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String string) {
        for (MutableTransition mutableTransition : this.transitions) {
            Condition condition = FSM.newMvelCondition(string, this.executionContext.getScriptManager());
            mutableTransition.setCondition(condition);
        }
        return this;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        for (MutableTransition<T, S, E, C> mutableTransition : this.transitions) {
            mutableTransition.addAction(action);
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> list) {
        int n = list.size();
        int n2 = this.transitions.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = i < n ? i : n - 1;
            this.transitions.get(i).addAction(list.get(n3));
        }
    }

    @Override
    public void evalMvel(String string) {
        for (MutableTransition mutableTransition : this.transitions) {
            Action action = FSM.newMvelAction(string, this.executionContext);
            mutableTransition.addAction(action);
        }
    }

    @Override
    public void callMethod(String string) {
        String[] stringArray = StringUtils.split(string, '|');
        int n = stringArray.length;
        int n2 = this.transitions.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = i < n ? i : n - 1;
            String string2 = stringArray[n3].trim();
            if ("_".equals(string2)) continue;
            MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(string2, this.executionContext);
            this.transitions.get(i).addAction(methodCallActionProxyImpl);
        }
    }
}

