/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.builder.EntryExitActionBuilder;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

class EntryExitActionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements EntryExitActionBuilder<T, S, E, C>,
SquirrelComponent {
    private final boolean isEntryAction;
    private final MutableState<T, S, E, C> state;
    private final ExecutionContext executionContext;

    EntryExitActionBuilderImpl(MutableState<T, S, E, C> mutableState, boolean bl, ExecutionContext executionContext) {
        this.state = mutableState;
        this.isEntryAction = bl;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        if (this.isEntryAction) {
            this.state.addEntryAction(action);
        } else {
            this.state.addExitAction(action);
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> list) {
        if (this.isEntryAction) {
            this.state.addEntryActions(list);
        } else {
            this.state.addExitActions(list);
        }
    }

    @Override
    public void evalMvel(String string) {
        Action action = FSM.newMvelAction(string, this.executionContext);
        this.perform(action);
    }

    @Override
    public void callMethod(String string) {
        MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(string, this.executionContext);
        this.perform(methodCallActionProxyImpl);
    }
}

