/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.event;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.event.AsyncEventListener;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.util.ReflectUtils;

public class ListenerMethod {
    private final Class<?> eventType;
    private final Object target;
    private final Method method;
    private boolean hasParameter = false;
    private final boolean isAsync;
    private final long timeout;

    public ListenerMethod(Class<?> clazz, Object object, Method method) {
        Preconditions.checkArgument(clazz != null && object != null && method != null, "Parameters cannot be null.");
        Preconditions.checkArgument(method.getDeclaringClass().isAssignableFrom(object.getClass()), "The method " + method.getName() + " cannot be used for the given target: " + object.getClass().getName());
        this.eventType = clazz;
        this.target = object;
        this.method = method;
        this.isAsync = AsyncEventListener.class.isAssignableFrom(object.getClass());
        this.timeout = this.isAsync ? ((AsyncEventListener)AsyncEventListener.class.cast(object)).timeout() : -1L;
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            if (classArray.length == 1 && classArray[0].isAssignableFrom(clazz)) {
                this.hasParameter = true;
            } else {
                throw new SquirrelRuntimeException(ErrorCodes.METHOD_UNEXPECTED_PARAMETERS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeMethod(final Object object) {
        Preconditions.checkArgument(this.eventType.isAssignableFrom(object.getClass()));
        if (this.isAsync) {
            SquirrelConfiguration.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray;
                    Method method = ListenerMethod.this.method;
                    Object object2 = ListenerMethod.this.target;
                    if (ListenerMethod.this.hasParameter) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = object;
                    } else {
                        objectArray = new Object[]{};
                    }
                    ReflectUtils.invoke(method, object2, objectArray);
                }
            });
        } else {
            Object object2 = this.target;
            synchronized (object2) {
                Object[] objectArray;
                if (this.hasParameter) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object;
                } else {
                    objectArray = new Object[]{};
                }
                ReflectUtils.invoke(this.method, this.target, objectArray);
            }
        }
    }

    public boolean matches(Class<?> clazz, Object object) {
        return this.target == object && clazz.equals(this.eventType);
    }

    public boolean matches(Class<?> clazz, Object object, Method method) {
        return this.target == object && clazz.equals(this.eventType) && method.equals(this.method);
    }

    public int hashCode() {
        int n = this.eventType.hashCode();
        n = 17 * n + this.target.hashCode();
        n = 17 * n + this.method.hashCode();
        return n;
    }

    public Class<?> getEventType() {
        return this.eventType;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ListenerMethod listenerMethod = (ListenerMethod)object;
        return (this.eventType == listenerMethod.eventType || this.eventType != null && this.eventType.equals(listenerMethod.eventType)) && (this.target == listenerMethod.target || this.target != null && this.target.equals(listenerMethod.target)) && (this.method == listenerMethod.method || this.method != null && this.method.equals(listenerMethod.method));
    }

    public String toString() {
        return this.target.getClass().getSimpleName() + '.' + this.method.getName() + '(' + this.eventType.getSimpleName() + ')';
    }
}

