/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils.counter.sampled;

import java.util.TimerTask;
import org.quartz.utils.CircularLossyQueue;
import org.quartz.utils.counter.CounterImpl;
import org.quartz.utils.counter.sampled.SampledCounter;
import org.quartz.utils.counter.sampled.SampledCounterConfig;
import org.quartz.utils.counter.sampled.TimeStampedCounterValue;

public class SampledCounterImpl
extends CounterImpl
implements SampledCounter {
    private static final long serialVersionUID = -3605369302464131521L;
    private static final int MILLIS_PER_SEC = 1000;
    protected final CircularLossyQueue<TimeStampedCounterValue> history;
    protected final boolean resetOnSample;
    private final TimerTask samplerTask;
    private final long intervalMillis;

    public SampledCounterImpl(SampledCounterConfig sampledCounterConfig) {
        super(sampledCounterConfig.getInitialValue());
        this.intervalMillis = sampledCounterConfig.getIntervalSecs() * 1000;
        this.history = new CircularLossyQueue(sampledCounterConfig.getHistorySize());
        this.resetOnSample = sampledCounterConfig.isResetOnSample();
        this.samplerTask = new TimerTask(){

            @Override
            public void run() {
                SampledCounterImpl.this.recordSample();
            }
        };
        this.recordSample();
    }

    @Override
    public TimeStampedCounterValue getMostRecentSample() {
        return this.history.peek();
    }

    @Override
    public TimeStampedCounterValue[] getAllSampleValues() {
        return this.history.toArray((TimeStampedCounterValue[])new TimeStampedCounterValue[this.history.depth()]);
    }

    @Override
    public void shutdown() {
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
        }
    }

    public TimerTask getTimerTask() {
        return this.samplerTask;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    void recordSample() {
        long l = this.resetOnSample ? this.getAndReset() : this.getValue();
        long l2 = System.currentTimeMillis();
        TimeStampedCounterValue timeStampedCounterValue = new TimeStampedCounterValue(l2, l);
        this.history.push(timeStampedCounterValue);
    }

    @Override
    public long getAndReset() {
        return this.getAndSet(0L);
    }
}

