/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.quartz.utils.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties props;
    private Object datasource;
    private boolean alwaysLookup = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JNDIConnectionProvider(String string, boolean bl) {
        this.url = string;
        this.alwaysLookup = bl;
        this.init();
    }

    public JNDIConnectionProvider(String string, Properties properties, boolean bl) {
        this.url = string;
        this.props = properties;
        this.alwaysLookup = bl;
        this.init();
    }

    protected Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.isAlwaysLookup()) {
            InitialContext initialContext = null;
            try {
                initialContext = this.props != null ? new InitialContext(this.props) : new InitialContext();
                this.datasource = (DataSource)initialContext.lookup(this.url);
            }
            catch (Exception exception) {
                this.getLog().error("Error looking up datasource: " + exception.getMessage(), exception);
            }
            finally {
                if (initialContext != null) {
                    try {
                        initialContext.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() throws SQLException {
        Context context = null;
        try {
            Object object = this.datasource;
            if (object == null || this.isAlwaysLookup()) {
                context = this.props != null ? new InitialContext(this.props) : new InitialContext();
                object = context.lookup(this.url);
                if (!this.isAlwaysLookup()) {
                    this.datasource = object;
                }
            }
            if (object == null) {
                throw new SQLException("There is no object at the JNDI URL '" + this.url + "'");
            }
            if (object instanceof XADataSource) {
                Connection connection = ((XADataSource)object).getXAConnection().getConnection();
                return connection;
            }
            if (object instanceof DataSource) {
                Connection connection = ((DataSource)object).getConnection();
                return connection;
            }
            throw new SQLException("Object at JNDI URL '" + this.url + "' is not a DataSource.");
        }
        catch (Exception exception) {
            this.datasource = null;
            throw new SQLException("Could not retrieve datasource via JNDI url '" + this.url + "' " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isAlwaysLookup() {
        return this.alwaysLookup;
    }

    public void setAlwaysLookup(boolean bl) {
        this.alwaysLookup = bl;
    }

    @Override
    public void shutdown() throws SQLException {
    }

    @Override
    public void initialize() throws SQLException {
    }
}

