/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.quartz.utils.ConnectionProvider;

public class DBConnectionManager {
    public static final String DB_PROPS_PREFIX = "org.quartz.db.";
    private static DBConnectionManager instance = new DBConnectionManager();
    private HashMap<String, ConnectionProvider> providers = new HashMap();

    private DBConnectionManager() {
    }

    public void addConnectionProvider(String string, ConnectionProvider connectionProvider) {
        this.providers.put(string, connectionProvider);
    }

    public Connection getConnection(String string) throws SQLException {
        ConnectionProvider connectionProvider = this.providers.get(string);
        if (connectionProvider == null) {
            throw new SQLException("There is no DataSource named '" + string + "'");
        }
        return connectionProvider.getConnection();
    }

    public static DBConnectionManager getInstance() {
        return instance;
    }

    public void shutdown(String string) throws SQLException {
        ConnectionProvider connectionProvider = this.providers.get(string);
        if (connectionProvider == null) {
            throw new SQLException("There is no DataSource named '" + string + "'");
        }
        connectionProvider.shutdown();
    }

    ConnectionProvider getConnectionProvider(String string) {
        return this.providers.get(string);
    }
}

