/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class CircularLossyQueue<T> {
    private final AtomicReference<T>[] circularArray;
    private final int maxSize;
    private final AtomicLong currentIndex = new AtomicLong(-1L);

    public CircularLossyQueue(int n) {
        this.circularArray = new AtomicReference[n];
        for (int i = 0; i < n; ++i) {
            this.circularArray[i] = new AtomicReference();
        }
        this.maxSize = n;
    }

    public void push(T t) {
        int n = (int)(this.currentIndex.incrementAndGet() % (long)this.maxSize);
        this.circularArray[n].set(t);
    }

    public T[] toArray(T[] TArray) {
        System.getProperties();
        if (TArray.length > this.maxSize) {
            throw new IllegalArgumentException("Size of array passed in cannot be greater than " + this.maxSize);
        }
        int n = this.getCurrentIndex();
        for (int i = 0; i < TArray.length; ++i) {
            int n2 = this.getIndex(n - i);
            TArray[i] = this.circularArray[n2].get();
        }
        return TArray;
    }

    private int getIndex(int n) {
        return n < 0 ? n + this.maxSize : n;
    }

    public T peek() {
        if (this.depth() == 0) {
            return null;
        }
        return this.circularArray[this.getIndex(this.getCurrentIndex())].get();
    }

    public boolean isEmtpy() {
        return this.depth() == 0;
    }

    private int getCurrentIndex() {
        return (int)(this.currentIndex.get() % (long)this.maxSize);
    }

    public int depth() {
        long l = this.currentIndex.get() + 1L;
        return l >= (long)this.maxSize ? this.maxSize : (int)l;
    }
}

