/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_COMMAND = "command";
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
    public static final String PROP_CONSUME_STREAMS = "consumeStreams";

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        String string = jobDataMap.getString(PROP_COMMAND);
        String string2 = jobDataMap.getString(PROP_PARAMETERS);
        if (string2 == null) {
            string2 = "";
        }
        boolean bl = true;
        if (jobDataMap.containsKey(PROP_WAIT_FOR_PROCESS)) {
            bl = jobDataMap.getBooleanValue(PROP_WAIT_FOR_PROCESS);
        }
        boolean bl2 = false;
        if (jobDataMap.containsKey(PROP_CONSUME_STREAMS)) {
            bl2 = jobDataMap.getBooleanValue(PROP_CONSUME_STREAMS);
        }
        Integer n = this.runNativeCommand(string, string2, bl, bl2);
        jobExecutionContext.setResult(n);
    }

    protected Logger getLog() {
        return this.log;
    }

    private Integer runNativeCommand(String string, String string2, boolean bl, boolean bl2) throws JobExecutionException {
        String[] stringArray = new String[2];
        Integer n = null;
        stringArray[0] = string;
        stringArray[1] = string2;
        try {
            String[] stringArray2;
            String string3 = System.getProperty("os.name");
            if (string3.startsWith("Windows")) {
                stringArray2 = new String[stringArray.length + 2];
                stringArray2[0] = string3.equals("Windows 95") ? "command.com" : "cmd.exe";
                stringArray2[1] = "/C";
                System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
            } else {
                stringArray2 = string3.equals("Linux") ? new String[]{"/bin/sh", "-c", stringArray[0] + " " + stringArray[1]} : stringArray;
            }
            Runtime runtime = Runtime.getRuntime();
            this.getLog().info("About to run " + stringArray2[0] + " " + stringArray2[1] + " " + (stringArray2.length > 2 ? stringArray2[2] : "") + " ...");
            Process process = runtime.exec(stringArray2);
            StreamConsumer streamConsumer = new StreamConsumer(process.getInputStream(), "stdout");
            if (bl2) {
                StreamConsumer streamConsumer2 = new StreamConsumer(process.getErrorStream(), "stderr");
                streamConsumer.start();
                streamConsumer2.start();
            }
            if (bl) {
                n = process.waitFor();
            }
        }
        catch (Throwable throwable) {
            throw new JobExecutionException("Error launching native command: ", throwable, false);
        }
        return n;
    }

    class StreamConsumer
    extends Thread {
        InputStream is;
        String type;

        public StreamConsumer(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(this.is));
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.type.equalsIgnoreCase("stderr")) {
                        NativeJob.this.getLog().warn(this.type + ">" + string);
                        continue;
                    }
                    NativeJob.this.getLog().info(this.type + ">" + string);
                }
            }
            catch (IOException iOException) {
                NativeJob.this.getLog().error("Error consuming " + this.type + " stream of spawned process.", iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

