/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE SCHED_NAME = {1} AND LOCK_NAME = ? FOR UPDATE";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";

    public StdRowLockSemaphore() {
        super("QRTZ_", null, SELECT_FOR_LOCK, INSERT_LOCK);
    }

    public StdRowLockSemaphore(String string, String string2, String string3) {
        super(string, string2, string3 != null ? string3 : SELECT_FOR_LOCK, INSERT_LOCK);
    }

    @Override
    protected void executeSQL(Connection connection, String string, String string2, String string3) throws LockException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SQLException sQLException = null;
        int n = 0;
        do {
            ++n;
            try {
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + string + "' is being obtained: " + Thread.currentThread().getName());
                }
                if (!(resultSet = preparedStatement.executeQuery()).next()) {
                    this.getLog().debug("Inserting new lock row for lock: '" + string + "' being obtained by thread: " + Thread.currentThread().getName());
                    resultSet.close();
                    resultSet = null;
                    preparedStatement.close();
                    preparedStatement = null;
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setString(1, string);
                    int n2 = preparedStatement.executeUpdate();
                    if (n2 != 1) {
                        if (n < 3) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + string, this.getTablePrefix(), this.getSchedulerNameLiteral()));
                    }
                }
                return;
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + string + "' was not obtained by: " + Thread.currentThread().getName() + (n < 3 ? " - will try again." : ""));
                }
                if (n < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw new LockException("Failure obtaining db row lock: " + sQLException2.getMessage(), sQLException2);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } while (n < 4);
        throw new LockException("Failure obtaining db row lock, reached maximum number of attempts. Initial exception (if any) attached as root cause.", sQLException);
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String string) {
        this.setSQL(string);
    }
}

