/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTANonClusteredSemaphore
implements Semaphore {
    public static final String DEFAULT_TRANSACTION_MANANGER_LOCATION = "java:TransactionManager";
    ThreadLocal<HashSet<String>> lockOwners = new ThreadLocal();
    HashSet<String> locks = new HashSet();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String transactionManagerJNDIName = "java:TransactionManager";

    protected Logger getLog() {
        return this.log;
    }

    public void setTransactionManagerJNDIName(String string) {
        this.transactionManagerJNDIName = string;
    }

    private HashSet<String> getThreadLocks() {
        HashSet<String> hashSet = this.lockOwners.get();
        if (hashSet == null) {
            hashSet = new HashSet();
            this.lockOwners.set(hashSet);
        }
        return hashSet;
    }

    @Override
    public synchronized boolean obtainLock(Connection connection, String string) throws LockException {
        string = string.intern();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' is desired by: " + Thread.currentThread().getName());
        }
        if (!this.isLockOwner(connection, string)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '" + string + "' is being obtained: " + Thread.currentThread().getName());
            }
            while (this.locks.contains(string)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Lock '" + string + "' was not obtained by: " + Thread.currentThread().getName());
                }
            }
            Transaction transaction = this.getTransaction();
            if (transaction != null) {
                try {
                    transaction.registerSynchronization((Synchronization)new SemaphoreSynchronization(string));
                }
                catch (Exception exception) {
                    throw new LockException("Failed to register semaphore with Transaction.", exception);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '" + string + "' given to: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().add(string);
            this.locks.add(string);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' already owned by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
        }
        return true;
    }

    protected Transaction getTransaction() throws LockException {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            TransactionManager transactionManager = (TransactionManager)initialContext.lookup(this.transactionManagerJNDIName);
            Transaction transaction = transactionManager.getTransaction();
            return transaction;
        }
        catch (SystemException systemException) {
            throw new LockException("Failed to get Transaction from TransactionManager", systemException);
        }
        catch (NamingException namingException) {
            throw new LockException("Failed to find TransactionManager in JNDI under name: " + this.transactionManagerJNDIName, namingException);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    @Override
    public synchronized void releaseLock(String string) throws LockException {
        this.releaseLock(string, false);
    }

    protected synchronized void releaseLock(String string, boolean bl) throws LockException {
        if (this.isLockOwner(null, string = string.intern())) {
            Transaction transaction;
            if (!bl && (transaction = this.getTransaction()) != null) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '" + string + "' is in a JTA transaction.  " + "Return deferred by: " + Thread.currentThread().getName());
                }
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + string + "' returned by: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(string);
            this.locks.remove(string);
            this.notify();
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Lock '" + string + "' attempt to return by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
        }
    }

    public synchronized boolean isLockOwner(Connection connection, String string) {
        string = string.intern();
        return this.getThreadLocks().contains(string);
    }

    @Override
    public boolean requiresConnection() {
        return false;
    }

    private class SemaphoreSynchronization
    implements Synchronization {
        private String lockName;

        public SemaphoreSynchronization(String string) {
            this.lockName = string;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            try {
                JTANonClusteredSemaphore.this.releaseLock(this.lockName, true);
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
    }
}

