/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CronTriggerPersistenceDelegate
implements TriggerPersistenceDelegate,
StdJDBCConstants {
    protected String tablePrefix;
    protected String schedNameLiteral;

    @Override
    public void initialize(String string, String string2) {
        this.tablePrefix = string;
        this.schedNameLiteral = "'" + string2 + "'";
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "CRON";
    }

    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof CronTriggerImpl && !((CronTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        CronTrigger cronTrigger = (CronTrigger)((Object)operableTrigger);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("INSERT INTO {0}CRON_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES({1}, ?, ?, ?, ?)", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, operableTrigger.getKey().getName());
            preparedStatement.setString(2, operableTrigger.getKey().getGroup());
            preparedStatement.setString(3, cronTrigger.getCronExpression());
            preparedStatement.setString(4, cronTrigger.getTimeZone().getID());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public TriggerPersistenceDelegate.TriggerPropertyBundle loadExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) throws SQLException {
        block4: {
            TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                String string = resultSet.getString("CRON_EXPRESSION");
                String string2 = resultSet.getString("TIME_ZONE_ID");
                CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(string);
                if (string2 != null) {
                    cronScheduleBuilder.inTimeZone(TimeZone.getTimeZone(string2));
                }
                triggerPropertyBundle = new TriggerPersistenceDelegate.TriggerPropertyBundle(cronScheduleBuilder, null, null);
            }
            catch (Throwable throwable) {
                Util.closeResultSet(resultSet);
                Util.closeStatement(preparedStatement);
                throw throwable;
            }
            Util.closeResultSet(resultSet);
            Util.closeStatement(preparedStatement);
            return triggerPropertyBundle;
        }
        throw new IllegalStateException("No record found for selection of Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        CronTrigger cronTrigger = (CronTrigger)((Object)operableTrigger);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ?, TIME_ZONE_ID = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, cronTrigger.getCronExpression());
            preparedStatement.setString(2, cronTrigger.getTimeZone().getID());
            preparedStatement.setString(3, operableTrigger.getKey().getName());
            preparedStatement.setString(4, operableTrigger.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }
}

