/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;

public class BaseCalendar
implements Calendar,
Serializable,
Cloneable {
    static final long serialVersionUID = 3106623404629760239L;
    private Calendar baseCalendar;
    private String description;
    private TimeZone timeZone;

    public BaseCalendar() {
    }

    public BaseCalendar(Calendar calendar) {
        this.setBaseCalendar(calendar);
    }

    public BaseCalendar(TimeZone timeZone) {
        this.setTimeZone(timeZone);
    }

    public BaseCalendar(Calendar calendar, TimeZone timeZone) {
        this.setBaseCalendar(calendar);
        this.setTimeZone(timeZone);
    }

    @Override
    public Object clone() {
        try {
            BaseCalendar baseCalendar = (BaseCalendar)super.clone();
            if (this.getBaseCalendar() != null) {
                baseCalendar.baseCalendar = (Calendar)this.getBaseCalendar().clone();
            }
            if (this.getTimeZone() != null) {
                baseCalendar.timeZone = (TimeZone)this.getTimeZone().clone();
            }
            return baseCalendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
    }

    @Override
    public void setBaseCalendar(Calendar calendar) {
        this.baseCalendar = calendar;
    }

    @Override
    public Calendar getBaseCalendar() {
        return this.baseCalendar;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        return this.baseCalendar == null || this.baseCalendar.isTimeIncluded(l);
    }

    @Override
    public long getNextIncludedTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        if (this.baseCalendar != null) {
            return this.baseCalendar.getNextIncludedTime(l);
        }
        return l;
    }

    protected java.util.Calendar createJavaCalendar(long l) {
        java.util.Calendar calendar = this.createJavaCalendar();
        calendar.setTime(new Date(l));
        return calendar;
    }

    protected java.util.Calendar createJavaCalendar() {
        return this.getTimeZone() == null ? java.util.Calendar.getInstance() : java.util.Calendar.getInstance(this.getTimeZone());
    }

    protected java.util.Calendar getStartOfDayJavaCalendar(long l) {
        java.util.Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected java.util.Calendar getEndOfDayJavaCalendar(long l) {
        java.util.Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }
}

