/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzInitializerListener
implements ServletContextListener {
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private boolean waitOnShutdown = false;
    private Scheduler scheduler = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.log.info("Quartz Initializer Servlet loaded, initializing Scheduler...");
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            String string;
            String string2 = servletContext.getInitParameter("quartz:config-file");
            if (string2 == null) {
                string2 = servletContext.getInitParameter("config-file");
            }
            if ((string = servletContext.getInitParameter("quartz:shutdown-on-unload")) == null) {
                string = servletContext.getInitParameter("shutdown-on-unload");
            }
            if (string != null) {
                this.performShutdown = Boolean.valueOf(string);
            }
            String string3 = servletContext.getInitParameter("quartz:wait-on-shutdown");
            if (string != null) {
                this.waitOnShutdown = Boolean.valueOf(string3);
            }
            StdSchedulerFactory stdSchedulerFactory = this.getSchedulerFactory(string2);
            this.scheduler = stdSchedulerFactory.getScheduler();
            String string4 = servletContext.getInitParameter("quartz:start-on-load");
            if (string4 == null) {
                string4 = servletContext.getInitParameter("start-scheduler-on-load");
            }
            int n = 0;
            String string5 = servletContext.getInitParameter("quartz:start-delay-seconds");
            if (string5 == null) {
                string5 = servletContext.getInitParameter("start-delay-seconds");
            }
            try {
                if (string5 != null && string5.trim().length() > 0) {
                    n = Integer.parseInt(string5);
                }
            }
            catch (Exception exception) {
                this.log.error("Cannot parse value of 'start-delay-seconds' to an integer: " + string5 + ", defaulting to 5 seconds.");
                n = 5;
            }
            if (string4 == null || Boolean.valueOf(string4).booleanValue()) {
                if (n <= 0) {
                    this.scheduler.start();
                    this.log.info("Scheduler has been started...");
                } else {
                    this.scheduler.startDelayed(n);
                    this.log.info("Scheduler will start in " + n + " seconds.");
                }
            } else {
                this.log.info("Scheduler has not been started. Use scheduler.start()");
            }
            String string6 = servletContext.getInitParameter("quartz:servlet-context-factory-key");
            if (string6 == null) {
                string6 = servletContext.getInitParameter("servlet-context-factory-key");
            }
            if (string6 == null) {
                string6 = QUARTZ_FACTORY_KEY;
            }
            this.log.info("Storing the Quartz Scheduler Factory in the servlet context at key: " + string6);
            servletContext.setAttribute(string6, (Object)stdSchedulerFactory);
            String string7 = servletContext.getInitParameter("quartz:scheduler-context-servlet-context-key");
            if (string7 == null) {
                string7 = servletContext.getInitParameter("scheduler-context-servlet-context-key");
            }
            if (string7 != null) {
                this.log.info("Storing the ServletContext in the scheduler context at key: " + string7);
                this.scheduler.getContext().put(string7, (Object)servletContext);
            }
        }
        catch (Exception exception) {
            this.log.error("Quartz Scheduler failed to initialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected StdSchedulerFactory getSchedulerFactory(String string) throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = string != null ? new StdSchedulerFactory(string) : new StdSchedulerFactory();
        return stdSchedulerFactory;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(this.waitOnShutdown);
            }
        }
        catch (Exception exception) {
            this.log.error("Quartz Scheduler failed to shutdown cleanly: " + exception.toString());
            exception.printStackTrace();
        }
        this.log.info("Quartz Scheduler successful shutdown.");
    }
}

