/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.SimpleTrigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.core.jmx.TriggerSupport;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.MutableTrigger;
import org.quartz.spi.OperableTrigger;

public class SimpleTriggerSupport {
    private static final String COMPOSITE_TYPE_NAME = "SimpleTrigger";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "SimpleTrigger Details";
    private static final String[] ITEM_NAMES = new String[]{"repeatCount", "repeatInterval", "timesTriggered"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"repeatCount", "repeatInterval", "timesTriggered"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.LONG, SimpleType.INTEGER};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "SimpleTrigger collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "SimpleTrigger collection";
    private static final TabularType TABULAR_TYPE;

    public static String[] getItemNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_NAMES));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemNames()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getItemDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_DESCRIPTIONS));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemDescriptions()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static OpenType[] getItemTypes() {
        ArrayList<OpenType> arrayList = new ArrayList<OpenType>(Arrays.asList(ITEM_TYPES));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemTypes()));
        return arrayList.toArray(new OpenType[arrayList.size()]);
    }

    public static CompositeData toCompositeData(SimpleTrigger simpleTrigger) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{simpleTrigger.getRepeatCount(), simpleTrigger.getRepeatInterval(), simpleTrigger.getTimesTriggered(), simpleTrigger.getKey().getName(), simpleTrigger.getKey().getGroup(), simpleTrigger.getJobKey().getName(), simpleTrigger.getJobKey().getGroup(), simpleTrigger.getDescription(), JobDataMapSupport.toTabularData(simpleTrigger.getJobDataMap()), simpleTrigger.getCalendarName(), ((OperableTrigger)((Object)simpleTrigger)).getFireInstanceId(), simpleTrigger.getMisfireInstruction(), simpleTrigger.getPriority(), simpleTrigger.getStartTime(), simpleTrigger.getEndTime(), simpleTrigger.getNextFireTime(), simpleTrigger.getPreviousFireTime(), simpleTrigger.getFinalFireTime()});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(List<? extends SimpleTrigger> list) {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        if (list != null) {
            ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
            for (SimpleTrigger simpleTrigger : list) {
                arrayList.add(SimpleTriggerSupport.toCompositeData(simpleTrigger));
            }
            tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        }
        return tabularDataSupport;
    }

    public static OperableTrigger newTrigger(CompositeData compositeData) throws ParseException {
        SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl();
        simpleTriggerImpl.setRepeatCount((Integer)compositeData.get("repeatCount"));
        simpleTriggerImpl.setRepeatInterval((Long)compositeData.get("repeatInterval"));
        simpleTriggerImpl.setTimesTriggered((Integer)compositeData.get("timesTriggered"));
        TriggerSupport.initializeTrigger((MutableTrigger)simpleTriggerImpl, compositeData);
        return simpleTriggerImpl;
    }

    public static OperableTrigger newTrigger(Map<String, Object> map) throws ParseException {
        SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl();
        if (map.containsKey("repeatCount")) {
            simpleTriggerImpl.setRepeatCount((Integer)map.get("repeatCount"));
        }
        if (map.containsKey("repeatInterval")) {
            simpleTriggerImpl.setRepeatInterval((Long)map.get("repeatInterval"));
        }
        if (map.containsKey("timesTriggered")) {
            simpleTriggerImpl.setTimesTriggered((Integer)map.get("timesTriggered"));
        }
        TriggerSupport.initializeTrigger((MutableTrigger)simpleTriggerImpl, map);
        return simpleTriggerImpl;
    }

    static {
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, SimpleTriggerSupport.getItemNames(), SimpleTriggerSupport.getItemDescriptions(), SimpleTriggerSupport.getItemTypes());
            TABULAR_TYPE = new TabularType("SimpleTrigger collection", "SimpleTrigger collection", COMPOSITE_TYPE, SimpleTriggerSupport.getItemNames());
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

