/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.core.jmx.JobDataMapSupport;

public class JobExecutionContextSupport {
    private static final String COMPOSITE_TYPE_NAME = "JobExecutionContext";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Job Execution Instance Details";
    private static final String[] ITEM_NAMES = new String[]{"schedulerName", "triggerName", "triggerGroup", "jobName", "jobGroup", "jobDataMap", "calendarName", "recovering", "refireCount", "fireTime", "scheduledFireTime", "previousFireTime", "nextFireTime", "jobRunTime", "fireInstanceId"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"schedulerName", "triggerName", "triggerGroup", "jobName", "jobGroup", "jobDataMap", "calendarName", "recovering", "refireCount", "fireTime", "scheduledFireTime", "previousFireTime", "nextFireTime", "jobRunTime", "fireInstanceId"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, JobDataMapSupport.TABULAR_TYPE, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.LONG, SimpleType.STRING};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "JobExecutionContextArray";
    private static final String TABULAR_TYPE_DESCRIPTION = "Array of composite JobExecutionContext";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;

    public static CompositeData toCompositeData(JobExecutionContext jobExecutionContext) throws SchedulerException {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{jobExecutionContext.getScheduler().getSchedulerName(), jobExecutionContext.getTrigger().getKey().getName(), jobExecutionContext.getTrigger().getKey().getGroup(), jobExecutionContext.getJobDetail().getKey().getName(), jobExecutionContext.getJobDetail().getKey().getGroup(), JobDataMapSupport.toTabularData(jobExecutionContext.getMergedJobDataMap()), jobExecutionContext.getTrigger().getCalendarName(), jobExecutionContext.isRecovering(), jobExecutionContext.getRefireCount(), jobExecutionContext.getFireTime(), jobExecutionContext.getScheduledFireTime(), jobExecutionContext.getPreviousFireTime(), jobExecutionContext.getNextFireTime(), jobExecutionContext.getJobRunTime(), jobExecutionContext.getFireInstanceId()});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(List<JobExecutionContext> list) throws SchedulerException {
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        for (JobExecutionContext jobExecutionContext : list) {
            arrayList.add(JobExecutionContextSupport.toCompositeData(jobExecutionContext));
        }
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        return tabularDataSupport;
    }

    static {
        INDEX_NAMES = new String[]{"schedulerName", "triggerName", "triggerGroup", "jobName", "jobGroup", "fireTime"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType(TABULAR_TYPE_NAME, TABULAR_TYPE_DESCRIPTION, COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

