/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.ArrayList;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.JobDetail;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.JobDetailImpl;

public class JobDetailSupport {
    private static final String COMPOSITE_TYPE_NAME = "JobDetail";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Job Execution Details";
    private static final String[] ITEM_NAMES = new String[]{"name", "group", "description", "jobClass", "jobDataMap", "durability", "shouldRecover"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"name", "group", "description", "jobClass", "jobDataMap", "durability", "shouldRecover"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, JobDataMapSupport.TABULAR_TYPE, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "JobDetail collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "JobDetail collection";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;

    public static JobDetail newJobDetail(CompositeData compositeData) throws ClassNotFoundException {
        Class<?> clazz;
        JobDetailImpl jobDetailImpl = new JobDetailImpl();
        int n = 0;
        jobDetailImpl.setName((String)compositeData.get(ITEM_NAMES[n++]));
        jobDetailImpl.setGroup((String)compositeData.get(ITEM_NAMES[n++]));
        jobDetailImpl.setDescription((String)compositeData.get(ITEM_NAMES[n++]));
        Class<?> clazz2 = clazz = Class.forName((String)compositeData.get(ITEM_NAMES[n++]));
        jobDetailImpl.setJobClass(clazz2);
        jobDetailImpl.setJobDataMap(JobDataMapSupport.newJobDataMap((TabularData)compositeData.get(ITEM_NAMES[n++])));
        jobDetailImpl.setDurability((Boolean)compositeData.get(ITEM_NAMES[n++]));
        jobDetailImpl.setRequestsRecovery((Boolean)compositeData.get(ITEM_NAMES[n++]));
        return jobDetailImpl;
    }

    public static JobDetail newJobDetail(Map<String, Object> map) throws ClassNotFoundException {
        Class<?> clazz;
        JobDetailImpl jobDetailImpl = new JobDetailImpl();
        int n = 0;
        jobDetailImpl.setName((String)map.get(ITEM_NAMES[n++]));
        jobDetailImpl.setGroup((String)map.get(ITEM_NAMES[n++]));
        jobDetailImpl.setDescription((String)map.get(ITEM_NAMES[n++]));
        Class<?> clazz2 = clazz = Class.forName((String)map.get(ITEM_NAMES[n++]));
        jobDetailImpl.setJobClass(clazz2);
        if (map.containsKey(ITEM_NAMES[n])) {
            Map map2 = (Map)map.get(ITEM_NAMES[n]);
            jobDetailImpl.setJobDataMap(JobDataMapSupport.newJobDataMap(map2));
        }
        if (map.containsKey(ITEM_NAMES[++n])) {
            jobDetailImpl.setDurability((Boolean)map.get(ITEM_NAMES[n]));
        }
        if (map.containsKey(ITEM_NAMES[++n])) {
            jobDetailImpl.setRequestsRecovery((Boolean)map.get(ITEM_NAMES[n]));
        }
        ++n;
        return jobDetailImpl;
    }

    public static CompositeData toCompositeData(JobDetail jobDetail) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{jobDetail.getKey().getName(), jobDetail.getKey().getGroup(), jobDetail.getDescription(), jobDetail.getJobClass().getName(), JobDataMapSupport.toTabularData(jobDetail.getJobDataMap()), jobDetail.isDurable(), jobDetail.requestsRecovery()});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(JobDetail[] jobDetailArray) {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        if (jobDetailArray != null) {
            ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
            for (JobDetail jobDetail : jobDetailArray) {
                arrayList.add(JobDetailSupport.toCompositeData(jobDetail));
            }
            tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        }
        return tabularDataSupport;
    }

    static {
        INDEX_NAMES = new String[]{"name", "group"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType("JobDetail collection", "JobDetail collection", COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

