/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Date;
import org.quartz.SchedulerException;

public class SchedulerMetaData
implements Serializable {
    private static final long serialVersionUID = 4203690002633917647L;
    private String schedName;
    private String schedInst;
    private Class<?> schedClass;
    private boolean isRemote;
    private boolean started;
    private boolean isInStandbyMode;
    private boolean shutdown;
    private Date startTime;
    private int numJobsExec;
    private Class<?> jsClass;
    private boolean jsPersistent;
    private boolean jsClustered;
    private Class<?> tpClass;
    private int tpSize;
    private String version;

    public SchedulerMetaData(String string, String string2, Class<?> clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, Date date, int n, Class<?> clazz2, boolean bl5, boolean bl6, Class<?> clazz3, int n2, String string3) {
        this.schedName = string;
        this.schedInst = string2;
        this.schedClass = clazz;
        this.isRemote = bl;
        this.started = bl2;
        this.isInStandbyMode = bl3;
        this.shutdown = bl4;
        this.startTime = date;
        this.numJobsExec = n;
        this.jsClass = clazz2;
        this.jsPersistent = bl5;
        this.jsClustered = bl6;
        this.tpClass = clazz3;
        this.tpSize = n2;
        this.version = string3;
    }

    public String getSchedulerName() {
        return this.schedName;
    }

    public String getSchedulerInstanceId() {
        return this.schedInst;
    }

    public Class<?> getSchedulerClass() {
        return this.schedClass;
    }

    public Date getRunningSince() {
        return this.startTime;
    }

    public int getNumberOfJobsExecuted() {
        return this.numJobsExec;
    }

    public boolean isSchedulerRemote() {
        return this.isRemote;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isInStandbyMode() {
        return this.isInStandbyMode;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public Class<?> getJobStoreClass() {
        return this.jsClass;
    }

    public boolean isJobStoreSupportsPersistence() {
        return this.jsPersistent;
    }

    public boolean isJobStoreClustered() {
        return this.jsClustered;
    }

    public Class<?> getThreadPoolClass() {
        return this.tpClass;
    }

    public int getThreadPoolSize() {
        return this.tpSize;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        try {
            return this.getSummary();
        }
        catch (SchedulerException schedulerException) {
            return "SchedulerMetaData: undeterminable.";
        }
    }

    public String getSummary() throws SchedulerException {
        StringBuilder stringBuilder = new StringBuilder("Quartz Scheduler (v");
        stringBuilder.append(this.getVersion());
        stringBuilder.append(") '");
        stringBuilder.append(this.getSchedulerName());
        stringBuilder.append("' with instanceId '");
        stringBuilder.append(this.getSchedulerInstanceId());
        stringBuilder.append("'\n");
        stringBuilder.append("  Scheduler class: '");
        stringBuilder.append(this.getSchedulerClass().getName());
        stringBuilder.append("'");
        if (this.isSchedulerRemote()) {
            stringBuilder.append(" - access via RMI.");
        } else {
            stringBuilder.append(" - running locally.");
        }
        stringBuilder.append("\n");
        if (!this.isShutdown()) {
            if (this.getRunningSince() != null) {
                stringBuilder.append("  Running since: ");
                stringBuilder.append(this.getRunningSince());
            } else {
                stringBuilder.append("  NOT STARTED.");
            }
            stringBuilder.append("\n");
            if (this.isInStandbyMode()) {
                stringBuilder.append("  Currently in standby mode.");
            } else {
                stringBuilder.append("  Not currently in standby mode.");
            }
        } else {
            stringBuilder.append("  Scheduler has been SHUTDOWN.");
        }
        stringBuilder.append("\n");
        stringBuilder.append("  Number of jobs executed: ");
        stringBuilder.append(this.getNumberOfJobsExecuted());
        stringBuilder.append("\n");
        stringBuilder.append("  Using thread pool '");
        stringBuilder.append(this.getThreadPoolClass().getName());
        stringBuilder.append("' - with ");
        stringBuilder.append(this.getThreadPoolSize());
        stringBuilder.append(" threads.");
        stringBuilder.append("\n");
        stringBuilder.append("  Using job-store '");
        stringBuilder.append(this.getJobStoreClass().getName());
        stringBuilder.append("' - which ");
        if (this.isJobStoreSupportsPersistence()) {
            stringBuilder.append("supports persistence.");
        } else {
            stringBuilder.append("does not support persistence.");
        }
        if (this.isJobStoreClustered()) {
            stringBuilder.append(" and is clustered.");
        } else {
            stringBuilder.append(" and is not clustered.");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

