/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeFactory;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleTypeEnvironment
extends HashMap<Type, Type>
implements TypeEnvironment {
    private static final long serialVersionUID = 1L;
    private final TypeSwitch<Type> substitute = new TypeSwitch<Type>(){

        @Override
        public Type caseClass(Class clazz) {
            return clazz;
        }

        @Override
        public Type caseGenericArrayType(GenericArrayType genericArrayType) {
            Type type;
            Type type2 = genericArrayType.getGenericComponentType();
            if (type2 == (type = SimpleTypeEnvironment.this.bind(type2))) {
                return genericArrayType;
            }
            return TypeFactory.createArrayType(type);
        }

        @Override
        public Type caseParameterizedType(ParameterizedType parameterizedType) {
            Object[] objectArray;
            Object[] objectArray2 = parameterizedType.getActualTypeArguments();
            if (this.areSame(objectArray2, objectArray = SimpleTypeEnvironment.this.substitute((Type[])objectArray2))) {
                return parameterizedType;
            }
            return TypeFactory.createParameterizedType(parameterizedType.getRawType(), (Type[])objectArray, parameterizedType.getOwnerType());
        }

        private boolean areSame(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == objectArray2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Type caseTypeVariable(TypeVariable typeVariable) {
            if (!SimpleTypeEnvironment.this.containsKey(typeVariable)) {
                return typeVariable;
            }
            return (Type)SimpleTypeEnvironment.this.get(typeVariable);
        }

        @Override
        public Type caseWildcardType(WildcardType wildcardType) {
            return wildcardType;
        }
    };

    public SimpleTypeEnvironment(Type[] typeArray, Type[] typeArray2) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.put(typeArray[i], typeArray2[i]);
        }
    }

    @Override
    public Type bind(Type type) {
        return this.substitute.doSwitch(type);
    }

    private Type[] substitute(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray2.length; ++i) {
            typeArray2[i] = this.bind(typeArray[i]);
        }
        return typeArray2;
    }
}

