/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXArrayType
extends JavaXType {
    public JavaXArrayType(Type type, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager) {
        super(type, typeEnvironment, javaReflectionManager);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public XClass getElementClass() {
        return this.toXClass(this.getElementType());
    }

    private Type getElementType() {
        return (Type)new TypeSwitch<Type>(){

            @Override
            public Type caseClass(Class clazz) {
                return clazz.getComponentType();
            }

            @Override
            public Type caseGenericArrayType(GenericArrayType genericArrayType) {
                return genericArrayType.getGenericComponentType();
            }

            @Override
            public Type defaultCase(Type type) {
                throw new IllegalArgumentException(type + " is not an array type");
            }
        }.doSwitch(this.approximate());
    }

    @Override
    public XClass getClassOrElementClass() {
        return this.getElementClass();
    }

    @Override
    public Class<? extends Collection> getCollectionClass() {
        return null;
    }

    @Override
    public XClass getMapKey() {
        return null;
    }

    @Override
    public XClass getType() {
        Class<? extends Object> clazz = this.getElementType();
        if (clazz instanceof Class) {
            clazz = this.arrayTypeOf(clazz);
        }
        return this.toXClass(clazz);
    }

    private Class<? extends Object> arrayTypeOf(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }
}

