/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFactory {
    public static <T extends Annotation> T create(AnnotationDescriptor annotationDescriptor) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Proxy.getProxyClass(classLoader, annotationDescriptor.type());
        AnnotationProxy annotationProxy = new AnnotationProxy(annotationDescriptor);
        try {
            return (T)AnnotationFactory.getProxyInstance(clazz, annotationProxy);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static <T extends Annotation> T getProxyInstance(Class<T> clazz, InvocationHandler invocationHandler) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = clazz.getConstructor(InvocationHandler.class);
        return (T)((Annotation)constructor.newInstance(invocationHandler));
    }
}

